/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.mzd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javastraw.reader.block.Block;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.block.DynamicBlock;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;

public class DynamicMatrixZoomData
extends MatrixZoomData {
    private final MatrixZoomData higherResZD;
    private final int scaleFactor;

    public DynamicMatrixZoomData(HiCZoom zoom, MatrixZoomData higherResZD) {
        super(higherResZD.chr1, higherResZD.chr2, zoom, higherResZD.blockBinCount, higherResZD.blockColumnCount, new int[0], new int[0], null);
        this.higherResZD = higherResZD;
        this.scaleFactor = zoom.getBinSize() / higherResZD.getBinSize();
    }

    @Override
    public List<Block> getNormalizedBlocksOverlapping(long binX1, long binY1, long binX2, long binY2, NormalizationType norm, boolean isImportant, boolean fillUnderDiagonal) {
        int higherBinX1 = (int)(binX1 * (long)this.scaleFactor);
        int higherBinY1 = (int)(binY1 * (long)this.scaleFactor);
        int higherBinX2 = (int)(binX2 * (long)this.scaleFactor);
        int higherBinY2 = (int)(binY2 * (long)this.scaleFactor);
        List<Block> blocksFromHigherRes = this.higherResZD.getNormalizedBlocksOverlapping(higherBinX1, higherBinY1, higherBinX2, higherBinY2, norm, isImportant, fillUnderDiagonal);
        return this.createBlocksForLowerRes(blocksFromHigherRes, norm);
    }

    private List<Block> createBlocksForLowerRes(List<Block> highResBlocks, NormalizationType norm) {
        HashMap condensedRecords = new HashMap();
        for (Block block : highResBlocks) {
            for (ContactRecord record : block.getContactRecords()) {
                int binX = record.getBinX() / this.scaleFactor;
                int binY = record.getBinY() / this.scaleFactor;
                float counts = record.getCounts();
                if (!condensedRecords.containsKey(binX)) {
                    condensedRecords.put(binX, new HashMap());
                }
                if (((Map)condensedRecords.get(binX)).containsKey(binY)) {
                    ((ContactRecord)((Map)condensedRecords.get(binX)).get(binY)).incrementCount(counts);
                    continue;
                }
                ContactRecord recordNew = new ContactRecord(binX, binY, counts);
                ((Map)condensedRecords.get(binX)).put(binY, recordNew);
            }
        }
        HashSet<Integer> blockNumbers = new HashSet<Integer>();
        Iterator iterator2 = condensedRecords.keySet().iterator();
        while (iterator2.hasNext()) {
            int bx = (Integer)iterator2.next();
            int cx = bx / this.blockBinCount;
            Map yMap = (Map)condensedRecords.get(bx);
            Iterator iterator3 = yMap.keySet().iterator();
            while (iterator3.hasNext()) {
                int by = (Integer)iterator3.next();
                ContactRecord cr = (ContactRecord)yMap.get(by);
                int ry = by / this.blockBinCount;
                int blockNumber = ry * this.blockColumnCount + cx;
                blockNumbers.add(blockNumber);
                String key = this.getBlockKey(blockNumber, norm);
                if (this.blockCache.containsKey(key)) {
                    DynamicBlock b3 = (DynamicBlock)this.blockCache.get(key);
                    b3.addContactRecord(cr);
                    continue;
                }
                DynamicBlock block = new DynamicBlock(blockNumber, cr, key);
                this.blockCache.put(key, block);
            }
        }
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (Integer num : blockNumbers) {
            arrayList.add((Block)this.blockCache.get(this.getBlockKey(num, norm)));
        }
        return arrayList;
    }

    @Override
    public void printFullDescription() {
        System.out.println("Dynamic Resolution Chromosome: " + this.chr1.getName() + " - " + this.chr2.getName());
        System.out.println("unit: " + (Object)((Object)this.zoom.getUnit()));
        System.out.println("binSize (bp): " + this.zoom.getBinSize());
    }
}

