/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.Iterator;
import javastraw.reader.DatasetReader;
import javastraw.reader.block.Block;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.iterators.ContactRecordIterator;
import javastraw.reader.iterators.IteratorContainer;
import javastraw.reader.iterators.ListIteratorContainer;
import javastraw.reader.mzd.MatrixZoomData;
import org.broad.igv.util.collections.LRUCache;

public class ZDIteratorContainer
extends IteratorContainer {
    private final LRUCache<String, Block> blockCache;
    private final DatasetReader reader;
    private final MatrixZoomData zd;
    private final boolean useCache;

    public ZDIteratorContainer(DatasetReader reader, MatrixZoomData zd, LRUCache<String, Block> blockCache, boolean useCache) {
        super(zd.getMatrixSize());
        this.reader = reader;
        this.zd = zd;
        this.blockCache = blockCache;
        this.useCache = useCache;
    }

    public static ListOfFloatArrays matrixVectorMultiplyOnIterator(Iterator<ContactRecord> iterator2, ListOfFloatArrays vector, long vectorLength) {
        ListOfDoubleArrays sumVector = new ListOfDoubleArrays(vectorLength);
        while (iterator2.hasNext()) {
            ContactRecord cr = iterator2.next();
            ListIteratorContainer.matrixVectorMult(vector, sumVector, cr);
        }
        return sumVector.convertToFloats();
    }

    @Override
    public Iterator<ContactRecord> getNewContactRecordIterator() {
        return new ContactRecordIterator(this.reader, this.zd, this.blockCache, this.useCache);
    }

    @Override
    public ListOfFloatArrays sparseMultiply(ListOfFloatArrays vector, long vectorLength) {
        return ZDIteratorContainer.matrixVectorMultiplyOnIterator(this.getNewContactRecordIterator(), vector, vectorLength);
    }

    @Override
    public void clear() {
    }
}

