/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.iterators.BigContactRecordList;
import javastraw.reader.iterators.IteratorContainer;
import javastraw.reader.iterators.ListIteratorContainer;
import javastraw.reader.iterators.ListOfListIterator;
import javastraw.tools.ParallelizationTools;

public class ListOfListIteratorContainer
extends IteratorContainer {
    private final BigContactRecordList allContactRecords;

    public ListOfListIteratorContainer(BigContactRecordList allContactRecords, long matrixSize) {
        super(matrixSize);
        this.setNumberOfContactRecords(allContactRecords.getTotalSize());
        this.allContactRecords = allContactRecords;
    }

    @Override
    public Iterator<ContactRecord> getNewContactRecordIterator() {
        return new ListOfListIterator(this.allContactRecords);
    }

    @Override
    public boolean getIsThereEnoughMemoryForNormCalculation() {
        return 4L * this.getMatrixSize() + 12L * this.getNumberOfContactRecords() < Runtime.getRuntime().maxMemory();
    }

    @Override
    public ListOfFloatArrays sparseMultiply(ListOfFloatArrays vector, long vectorLength) {
        if (this.allContactRecords.getNumLists() < numCPUMatrixThreads) {
            ListOfFloatArrays totalSumVector = new ListOfFloatArrays(vectorLength);
            for (int k = 0; k < this.allContactRecords.getNumLists(); ++k) {
                List<ContactRecord> contactRecords = this.allContactRecords.getSubList(k);
                totalSumVector.addValuesFrom(ListIteratorContainer.sparseMultiplyByListContacts(contactRecords, vector, vectorLength, numCPUMatrixThreads));
            }
            return totalSumVector;
        }
        return this.sparseMultiplyAcrossLists(vector, vectorLength);
    }

    @Override
    public void clear() {
        this.allContactRecords.clear();
    }

    private ListOfFloatArrays sparseMultiplyAcrossLists(ListOfFloatArrays vector, long vectorLength) {
        ListOfDoubleArrays totalSumVector = new ListOfDoubleArrays(vectorLength);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(numCPUMatrixThreads, () -> {
            int sIndx = index.getAndIncrement();
            ListOfDoubleArrays sumVector = new ListOfDoubleArrays(vectorLength);
            while (sIndx < this.allContactRecords.getNumLists()) {
                for (ContactRecord cr : this.allContactRecords.getSubList(sIndx)) {
                    ListIteratorContainer.matrixVectorMult(vector, sumVector, cr);
                }
                sIndx = index.getAndIncrement();
            }
            ListOfDoubleArrays listOfDoubleArrays = totalSumVector;
            synchronized (listOfDoubleArrays) {
                totalSumVector.addValuesFrom(sumVector);
            }
        });
        return totalSumVector.convertToFloats();
    }
}

