/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.Iterator;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.iterators.BigContactRecordList;

public class ListOfListIterator
implements Iterator<ContactRecord> {
    private final BigContactRecordList allContactRecords;
    private Iterator<ContactRecord> currentIterator = null;
    private int currentListIndex = 0;

    public ListOfListIterator(BigContactRecordList allContactRecords) {
        this.allContactRecords = allContactRecords;
        this.getNextIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        ++this.currentListIndex;
        return this.getNextIterator();
    }

    private boolean getNextIterator() {
        while (this.currentListIndex < this.allContactRecords.getNumLists()) {
            this.currentIterator = this.allContactRecords.getSubList(this.currentListIndex).iterator();
            if (this.currentIterator.hasNext()) {
                return true;
            }
            ++this.currentListIndex;
        }
        return false;
    }

    @Override
    public ContactRecord next() {
        return this.currentIterator.next();
    }
}

