/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.Dataset;
import javastraw.reader.DatasetReader;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.Block;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.iterators.BigContactRecordList;
import javastraw.reader.iterators.GWIteratorContainer;
import javastraw.reader.iterators.IteratorContainer;
import javastraw.reader.iterators.ListOfListIteratorContainer;
import javastraw.reader.iterators.ZDIteratorContainer;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.tools.ParallelizationTools;
import org.broad.igv.util.collections.LRUCache;

public class ListOfListGenerator {
    public static IteratorContainer createFromZD(DatasetReader reader, MatrixZoomData matrixZoomData, LRUCache<String, Block> blockCache, boolean useCache, boolean useIteratorDontPutAllInRAM, boolean shouldCheckRAMUsage) {
        ZDIteratorContainer ic = new ZDIteratorContainer(reader, matrixZoomData, blockCache, useCache);
        return ListOfListGenerator.tryToCreateIteratorInRAM(ic, useIteratorDontPutAllInRAM, shouldCheckRAMUsage);
    }

    public static IteratorContainer createForWholeGenome(Dataset dataset, ChromosomeHandler chromosomeHandler, HiCZoom zoom, boolean includeIntraData, boolean useIteratorDontPutAllInRAM, boolean shouldCheckRAMUsage) {
        GWIteratorContainer ic = new GWIteratorContainer(dataset, chromosomeHandler, zoom, includeIntraData);
        return ListOfListGenerator.tryToCreateIteratorInRAM(ic, useIteratorDontPutAllInRAM, shouldCheckRAMUsage);
    }

    private static IteratorContainer tryToCreateIteratorInRAM(IteratorContainer ic0, boolean useIteratorDontPutAllInRAM, boolean shouldCheckRAMUsage) {
        if (useIteratorDontPutAllInRAM) {
            return ic0;
        }
        try {
            boolean shouldFitInMemory = true;
            if (shouldCheckRAMUsage) {
                shouldFitInMemory = ListOfListGenerator.checkMemory(ic0);
            }
            if (shouldFitInMemory) {
                BigContactRecordList allContactRecords = ListOfListGenerator.populateListOfLists(ic0);
                return new ListOfListIteratorContainer(allContactRecords, ic0.getMatrixSize());
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.err.println("Will use default iterator");
        }
        return ic0;
    }

    private static BigContactRecordList populateListOfLists(IteratorContainer ic) {
        if (ic instanceof GWIteratorContainer) {
            List<Iterator<ContactRecord>> iterators = ((GWIteratorContainer)ic).getAllFromFileContactRecordIterators();
            BigContactRecordList allRecords = new BigContactRecordList();
            AtomicInteger index = new AtomicInteger(0);
            ParallelizationTools.launchParallelizedCode(IteratorContainer.numCPUMatrixThreads, () -> {
                int i = index.getAndIncrement();
                BigContactRecordList recordsForThread = new BigContactRecordList();
                while (i < iterators.size()) {
                    BigContactRecordList recordsForIter = BigContactRecordList.populateListOfListsFromSingleIterator((Iterator)iterators.get(i));
                    recordsForThread.addAllSubLists(recordsForIter);
                    i = index.getAndIncrement();
                }
                BigContactRecordList bigContactRecordList = allRecords;
                synchronized (bigContactRecordList) {
                    allRecords.addAllSubLists(recordsForThread);
                }
            });
            return allRecords;
        }
        return BigContactRecordList.populateListOfListsFromSingleIterator(ic.getNewContactRecordIterator());
    }

    private static boolean checkMemory(IteratorContainer ic) {
        long ramForAllContactRecords;
        long ramForRowSums = ic.getMatrixSize() * 4L;
        return ramForRowSums + (ramForAllContactRecords = ic.getNumberOfContactRecords() * 12L) < Runtime.getRuntime().maxMemory();
    }
}

