/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.iterators.IteratorContainer;
import javastraw.reader.iterators.ParallelizedListOperations;
import javastraw.tools.ParallelizationTools;

public class ListIteratorContainer
extends IteratorContainer {
    protected final List<ContactRecord> readList;

    public ListIteratorContainer(List<ContactRecord> readList, long matrixSize) {
        super(matrixSize);
        this.setNumberOfContactRecords(readList.size());
        this.readList = readList;
    }

    public static ListOfFloatArrays sparseMultiplyByListContacts(List<ContactRecord> readList, ListOfFloatArrays vector, long vectorLength, int numThreads) {
        ListOfDoubleArrays totalSumVector = new ListOfDoubleArrays(vectorLength);
        int[] cutoffs = ParallelizedListOperations.createCutoffs(numThreads, readList.size());
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(numThreads, () -> {
            int sIndx = index.getAndIncrement();
            ListOfDoubleArrays sumVector = new ListOfDoubleArrays(vectorLength);
            for (int i = cutoffs[sIndx]; i < cutoffs[sIndx + 1]; ++i) {
                ContactRecord cr = (ContactRecord)readList.get(i);
                ListIteratorContainer.matrixVectorMult(vector, sumVector, cr);
            }
            ListOfDoubleArrays listOfDoubleArrays = totalSumVector;
            synchronized (listOfDoubleArrays) {
                totalSumVector.addValuesFrom(sumVector);
            }
        });
        return totalSumVector.convertToFloats();
    }

    public static void matrixVectorMult(ListOfFloatArrays vector, ListOfDoubleArrays sumVector, ContactRecord cr) {
        int x = cr.getBinX();
        int y = cr.getBinY();
        double counts = cr.getCounts();
        if (x == y) {
            counts *= 0.5;
        }
        sumVector.addTo(x, counts * (double)vector.get(y));
        sumVector.addTo(y, counts * (double)vector.get(x));
    }

    @Override
    public Iterator<ContactRecord> getNewContactRecordIterator() {
        return this.readList.iterator();
    }

    @Override
    public boolean getIsThereEnoughMemoryForNormCalculation() {
        return 4L * this.getMatrixSize() + 12L * this.getNumberOfContactRecords() < Runtime.getRuntime().maxMemory();
    }

    @Override
    public ListOfFloatArrays sparseMultiply(ListOfFloatArrays vector, long vectorLength) {
        return ListIteratorContainer.sparseMultiplyByListContacts(this.readList, vector, vectorLength, numCPUMatrixThreads);
    }

    @Override
    public void clear() {
        this.readList.clear();
    }
}

