/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.Iterator;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.datastructures.ListOfFloatArrays;

public abstract class IteratorContainer {
    private final long matrixSize;
    private long numberOfContactRecords = -1L;
    public static int numCPUMatrixThreads = 10;

    public IteratorContainer(long matrixSize) {
        this.matrixSize = matrixSize;
    }

    protected static ListOfFloatArrays[] getArrayOfFloatVectors(int size, long vectorLength) {
        ListOfFloatArrays[] array = new ListOfFloatArrays[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new ListOfFloatArrays(vectorLength);
        }
        return array;
    }

    protected static ListOfDoubleArrays[] getArrayOfDoubleVectors(int size, long vectorLength) {
        ListOfDoubleArrays[] array = new ListOfDoubleArrays[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new ListOfDoubleArrays(vectorLength);
        }
        return array;
    }

    public long getNumberOfContactRecords() {
        if (this.numberOfContactRecords > 0L) {
            return this.numberOfContactRecords;
        }
        this.numberOfContactRecords = 0L;
        Iterator<ContactRecord> iterator2 = this.getNewContactRecordIterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            ++this.numberOfContactRecords;
        }
        return this.numberOfContactRecords;
    }

    public long getMatrixSize() {
        return this.matrixSize;
    }

    public abstract Iterator<ContactRecord> getNewContactRecordIterator();

    protected void setNumberOfContactRecords(long numberOfContactRecords) {
        this.numberOfContactRecords = numberOfContactRecords;
    }

    public boolean getIsThereEnoughMemoryForNormCalculation() {
        return this.matrixSize * 4L < Runtime.getRuntime().maxMemory();
    }

    public abstract ListOfFloatArrays sparseMultiply(ListOfFloatArrays var1, long var2);

    public abstract void clear();
}

