/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.iterators.CoupledIteratorAndOffset;
import javastraw.reader.iterators.IteratorContainer;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.tools.HiCFileTools;

public class GenomeWideIterator
implements Iterator<ContactRecord> {
    private final Chromosome[] chromosomes;
    private final boolean includeIntra;
    private final HiCZoom zoom;
    private final Dataset dataset;
    private Iterator<ContactRecord> currentIterator = null;
    private int recentAddX = 0;
    private int recentAddY = 0;
    private int c1i = 0;
    private int c2i = 0;

    public GenomeWideIterator(Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra) {
        this.chromosomes = handler.getChromosomeArrayWithoutAllByAll();
        this.includeIntra = includeIntra;
        this.zoom = zoom;
        this.dataset = dataset;
        this.getNextIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        this.recentAddY = (int)((long)this.recentAddY + (this.chromosomes[this.c2i].getLength() / (long)this.zoom.getBinSize() + 1L));
        ++this.c2i;
        return this.getNextIterator();
    }

    public static List<Iterator<ContactRecord>> getAllFromFileIterators(Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra) {
        Chromosome[] chromosomes = handler.getChromosomeArrayWithoutAllByAll();
        ArrayList<Iterator<ContactRecord>> allIterators = new ArrayList<Iterator<ContactRecord>>();
        int xOffset = 0;
        for (int i = 0; i < chromosomes.length; ++i) {
            Chromosome c1 = chromosomes[i];
            int yOffset = 0 + xOffset;
            for (int j = i; j < chromosomes.length; ++j) {
                IteratorContainer ic;
                Iterator<ContactRecord> iterator2;
                MatrixZoomData zd;
                Chromosome c2 = chromosomes[j];
                if ((c1.getIndex() < c2.getIndex() || c1.equals(c2) && includeIntra) && (zd = HiCFileTools.getMatrixZoomData(dataset, c1, c2, zoom)) != null && (iterator2 = (ic = zd.getFromFileIteratorContainer()).getNewContactRecordIterator()) != null && iterator2.hasNext()) {
                    allIterators.add(new CoupledIteratorAndOffset(iterator2, xOffset, yOffset));
                }
                yOffset = (int)((long)yOffset + (c2.getLength() / (long)zoom.getBinSize() + 1L));
            }
            xOffset = (int)((long)xOffset + (c1.getLength() / (long)zoom.getBinSize() + 1L));
        }
        return allIterators;
    }

    private boolean getNextIterator() {
        while (this.c1i < this.chromosomes.length) {
            Chromosome c1 = this.chromosomes[this.c1i];
            while (this.c2i < this.chromosomes.length) {
                Iterator<ContactRecord> newIterator;
                MatrixZoomData zd;
                Chromosome c2 = this.chromosomes[this.c2i];
                if ((c1.getIndex() < c2.getIndex() || c1.equals(c2) && this.includeIntra) && (zd = HiCFileTools.getMatrixZoomData(this.dataset, c1, c2, this.zoom)) != null && (newIterator = zd.getFromFileIteratorContainer().getNewContactRecordIterator()) != null && newIterator.hasNext()) {
                    this.currentIterator = new CoupledIteratorAndOffset(newIterator, this.recentAddX, this.recentAddY);
                    return true;
                }
                this.recentAddY = (int)((long)this.recentAddY + (c2.getLength() / (long)this.zoom.getBinSize() + 1L));
                ++this.c2i;
            }
            this.recentAddX = (int)((long)this.recentAddX + (c1.getLength() / (long)this.zoom.getBinSize() + 1L));
            this.recentAddY = 0 + this.recentAddX;
            this.c2i = ++this.c1i;
        }
        return false;
    }

    @Override
    public ContactRecord next() {
        return this.currentIterator.next();
    }
}

