/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.iterators.GenomeWideIterator;
import javastraw.reader.iterators.IteratorContainer;
import javastraw.reader.iterators.ZDIteratorContainer;
import javastraw.reader.type.HiCZoom;
import javastraw.tools.ParallelizationTools;

public class GWIteratorContainer
extends IteratorContainer {
    private final Dataset dataset;
    private final ChromosomeHandler handler;
    private final HiCZoom zoom;
    private final boolean includeIntra;

    public GWIteratorContainer(Dataset dataset, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra) {
        super(GWIteratorContainer.calculateMatrixSize(handler, zoom));
        this.dataset = dataset;
        this.handler = handler;
        this.zoom = zoom;
        this.includeIntra = includeIntra;
    }

    private static long calculateMatrixSize(ChromosomeHandler handler, HiCZoom zoom) {
        long totalSize = 0L;
        for (Chromosome c1 : handler.getChromosomeArrayWithoutAllByAll()) {
            totalSize += c1.getLength() / (long)zoom.getBinSize() + 1L;
        }
        return totalSize;
    }

    @Override
    public Iterator<ContactRecord> getNewContactRecordIterator() {
        return new GenomeWideIterator(this.dataset, this.handler, this.zoom, this.includeIntra);
    }

    public List<Iterator<ContactRecord>> getAllFromFileContactRecordIterators() {
        return GenomeWideIterator.getAllFromFileIterators(this.dataset, this.handler, this.zoom, this.includeIntra);
    }

    @Override
    public ListOfFloatArrays sparseMultiply(ListOfFloatArrays vector, long vectorLength) {
        ListOfFloatArrays totalSumVector = new ListOfFloatArrays(vectorLength);
        List<Iterator<ContactRecord>> allIterators = this.getAllFromFileContactRecordIterators();
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(numCPUMatrixThreads, () -> {
            int i = index.getAndIncrement();
            ListOfFloatArrays accumSumVector = new ListOfFloatArrays(vectorLength);
            while (i < allIterators.size()) {
                accumSumVector.addValuesFrom(ZDIteratorContainer.matrixVectorMultiplyOnIterator((Iterator)allIterators.get(i), vector, vectorLength));
                i = index.getAndIncrement();
            }
            ListOfFloatArrays listOfFloatArrays = totalSumVector;
            synchronized (listOfFloatArrays) {
                totalSumVector.addValuesFrom(accumSumVector);
            }
        });
        allIterators.clear();
        return totalSumVector;
    }

    @Override
    public void clear() {
    }
}

