/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javastraw.reader.DatasetReader;
import javastraw.reader.block.Block;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.NormalizationHandler;
import org.broad.igv.util.collections.LRUCache;

public class ContactRecordIterator
implements Iterator<ContactRecord> {
    private final List<Integer> blockNumbers;
    private int blockIdx;
    private Iterator<ContactRecord> currentBlockIterator;
    private final DatasetReader reader;
    private final MatrixZoomData zd;
    private final LRUCache<String, Block> blockCache;
    private final boolean useCache;

    ContactRecordIterator(DatasetReader reader, MatrixZoomData zd, LRUCache<String, Block> blockCache, boolean useCache) {
        this.reader = reader;
        this.zd = zd;
        this.blockCache = blockCache;
        this.blockIdx = -1;
        this.blockNumbers = reader.getBlockNumbers(zd);
        this.useCache = useCache;
    }

    @Override
    public boolean hasNext() {
        if (this.currentBlockIterator != null && this.currentBlockIterator.hasNext()) {
            return true;
        }
        ++this.blockIdx;
        if (this.blockIdx < this.blockNumbers.size()) {
            try {
                int blockNumber = this.blockNumbers.get(this.blockIdx);
                String key = this.zd.getBlockKey(blockNumber, NormalizationHandler.NONE);
                Block nextBlock = this.useCache && this.blockCache.containsKey(key) ? this.blockCache.get(key) : this.reader.readNormalizedBlock(blockNumber, this.zd, NormalizationHandler.NONE);
                this.currentBlockIterator = nextBlock.getContactRecords().iterator();
                return true;
            }
            catch (IOException e) {
                System.err.println("Error fetching block " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public ContactRecord next() {
        return this.currentBlockIterator == null ? null : this.currentBlockIterator.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("remove() is not supported");
    }
}

