/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javastraw.reader.block.ContactRecord;

public class BigContactRecordList {
    public static final int MAX_LIMIT = 0x7FFFFFF5;
    private List<List<ContactRecord>> internalList = new ArrayList<List<ContactRecord>>();
    private long numOfContactRecords = 0L;

    public static BigContactRecordList populateListOfListsFromSingleIterator(Iterator<ContactRecord> iterator2) {
        BigContactRecordList allRecords = new BigContactRecordList();
        ArrayList<ContactRecord> tempList = new ArrayList<ContactRecord>();
        int counter = 0;
        while (iterator2.hasNext()) {
            tempList.add(iterator2.next());
            if (++counter <= 0x7FFFFFF5) continue;
            allRecords.addSubList(tempList);
            tempList = new ArrayList();
            counter = 0;
        }
        if (tempList.size() > 0) {
            allRecords.addSubList(tempList);
        }
        return allRecords;
    }

    public static BigContactRecordList populateFromListOfLists(List<List<ContactRecord>> allContactLists) {
        BigContactRecordList allRecords = new BigContactRecordList();
        for (List<ContactRecord> tempList : allContactLists) {
            allRecords.addSubList(tempList);
        }
        return allRecords;
    }

    public void addAllSubLists(BigContactRecordList other) {
        this.internalList.addAll(other.internalList);
        for (List<ContactRecord> records : other.internalList) {
            this.numOfContactRecords += (long)records.size();
        }
    }

    private void addSubList(List<ContactRecord> cList) {
        this.internalList.add(cList);
        this.numOfContactRecords += (long)cList.size();
    }

    public long getTotalSize() {
        return this.numOfContactRecords;
    }

    public int getNumLists() {
        return this.internalList.size();
    }

    public List<ContactRecord> getSubList(int index) {
        return this.internalList.get(index);
    }

    public void clear() {
        for (List<ContactRecord> cList : this.internalList) {
            cList.clear();
        }
        this.internalList.clear();
        this.internalList = new ArrayList<List<ContactRecord>>();
        this.numOfContactRecords = 0L;
    }

    public void sort() {
        this.internalList.sort(Comparator.comparing(o -> (ContactRecord)o.get(0)));
    }

    public void collapse() {
        System.out.println("Was n " + this.internalList.size());
        int numFinList = (int)Math.max(this.numOfContactRecords / 200000000L, 20L);
        ArrayList<List<ContactRecord>> newInternalList = new ArrayList<List<ContactRecord>>();
        int[] countForList = new int[numFinList];
        Arrays.fill(countForList, 0);
        for (int z = 0; z < numFinList; ++z) {
            newInternalList.add(new ArrayList());
        }
        for (List<ContactRecord> subList : this.internalList) {
            int whichIndexToAddTo;
            int n = whichIndexToAddTo = this.getIndexOfMin(countForList);
            countForList[n] = countForList[n] + subList.size();
            ((List)newInternalList.get(whichIndexToAddTo)).addAll(subList);
        }
        this.internalList.clear();
        this.internalList = newInternalList;
        System.out.println("Now is n " + this.internalList.size());
    }

    private int getIndexOfMin(int[] counts) {
        int minIndex = 0;
        for (int k = 1; k < counts.length; ++k) {
            if (counts[k] >= counts[minIndex]) continue;
            minIndex = k;
        }
        return minIndex;
    }
}

