/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.datastructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.expected.QuickMedian;

public class ListOfDoubleArrays {
    private final long DEFAULT_LENGTH = 0x7FFFFFF5L;
    private final long overallLength;
    private final List<double[]> internalList = new ArrayList<double[]>();

    public ListOfDoubleArrays(long length) {
        this.overallLength = length;
        for (long tempLength = length; tempLength > 0L; tempLength -= 0x7FFFFFF5L) {
            if (tempLength < 0x7FFFFFF5L) {
                this.internalList.add(new double[(int)tempLength]);
                break;
            }
            this.internalList.add(new double[0x7FFFFFF5]);
        }
    }

    public ListOfDoubleArrays(long totSize, double defaultValue) {
        this(totSize);
        for (double[] array : this.internalList) {
            Arrays.fill(array, defaultValue);
        }
    }

    public void clear() {
        this.internalList.clear();
    }

    public double get(long index) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 0x7FFFFFF5L);
            int pseudoCol = (int)(index % 0x7FFFFFF5L);
            return this.internalList.get(pseudoRow)[pseudoCol];
        }
        System.err.println("long index exceeds max size of list of arrays while getting: " + index + " " + this.overallLength);
        Exception ioe = new Exception();
        ioe.printStackTrace();
        return Double.NaN;
    }

    public void set(long index, double value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 0x7FFFFFF5L);
            int pseudoCol = (int)(index % 0x7FFFFFF5L);
            this.internalList.get((int)pseudoRow)[pseudoCol] = value;
        } else {
            System.err.println("long index exceeds max size of list of arrays while setting");
        }
    }

    public long getLength() {
        return this.overallLength;
    }

    public ListOfDoubleArrays deepClone() {
        ListOfDoubleArrays clone = new ListOfDoubleArrays(this.overallLength);
        for (int k = 0; k < this.internalList.size(); ++k) {
            System.arraycopy(this.internalList.get(k), 0, clone.internalList.get(k), 0, this.internalList.get(k).length);
        }
        return clone;
    }

    public void divideBy(long index, double value) {
        if (index >= this.overallLength) {
            System.err.println("long index exceeds max size of list of arrays while dividing");
            return;
        }
        int pseudoRow = (int)(index / 0x7FFFFFF5L);
        int pseudoCol = (int)(index % 0x7FFFFFF5L);
        double[] dArray = this.internalList.get(pseudoRow);
        int n = pseudoCol;
        dArray[n] = dArray[n] / value;
    }

    public void multiplyBy(long index, double value) {
        if (index >= this.overallLength) {
            System.err.println("long index exceeds max size of list of arrays while mutiplying");
            return;
        }
        int pseudoRow = (int)(index / 0x7FFFFFF5L);
        int pseudoCol = (int)(index % 0x7FFFFFF5L);
        double[] dArray = this.internalList.get(pseudoRow);
        int n = pseudoCol;
        dArray[n] = dArray[n] * value;
    }

    public void addTo(long index, double value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 0x7FFFFFF5L);
            int pseudoCol = (int)(index % 0x7FFFFFF5L);
            try {
                double[] dArray = this.internalList.get(pseudoRow);
                int n = pseudoCol;
                dArray[n] = dArray[n] + value;
            }
            catch (Exception e) {
                System.err.println(index + " " + pseudoCol);
                e.printStackTrace();
            }
        } else {
            System.err.println("long index exceeds max size of list of arrays while adding: " + index + " " + this.overallLength);
            Exception ioe = new Exception();
            ioe.printStackTrace();
        }
    }

    public void addValuesFrom(ListOfDoubleArrays other) {
        if (this.overallLength == other.overallLength) {
            for (int i = 0; i < this.internalList.size(); ++i) {
                for (int j = 0; j < this.internalList.get(i).length; ++j) {
                    double[] dArray = this.internalList.get(i);
                    int n = j;
                    dArray[n] = dArray[n] + other.internalList.get(i)[j];
                }
            }
        } else {
            System.err.println("Adding objects of different sizes!");
        }
    }

    public double getFirstValue() {
        return this.internalList.get(0)[0];
    }

    public double getLastValue() {
        double[] temp = this.internalList.get(this.internalList.size() - 1);
        return temp[temp.length - 1];
    }

    public List<double[]> getValues() {
        return this.internalList;
    }

    public void multiplyEverythingBy(double val) {
        for (double[] array : this.internalList) {
            int k = 0;
            while (k < array.length) {
                int n = k++;
                array[n] = array[n] * val;
            }
        }
    }

    public ListOfFloatArrays convertToFloats() {
        ListOfFloatArrays newList = new ListOfFloatArrays(this.overallLength);
        for (int j = 0; j < this.internalList.size(); ++j) {
            for (int k = 0; k < this.internalList.get(j).length; ++k) {
                newList.getValues().get((int)j)[k] = (float)this.internalList.get(j)[k];
            }
        }
        return newList;
    }

    public void doRollingMeanFromIndex(int startIndex, int window) {
        double[] data;
        if ((long)startIndex > 0x7FFFFFF5L || this.internalList.size() > 1) {
            System.err.println("ERROR: NOT YET IMPLEMENTED!!!");
            System.exit(-3);
        }
        if (startIndex >= (data = this.internalList.get(0)).length) {
            return;
        }
        double[] secondArray = new double[data.length - startIndex];
        for (int z = 0; z < secondArray.length; ++z) {
            secondArray[z] = this.getSafeMean(data, startIndex + z - window, startIndex + z + window);
        }
        System.arraycopy(secondArray, 0, data, startIndex, secondArray.length);
    }

    private double getSafeMean(double[] data, int potentialStart, int potentialEnd) {
        int start = Math.max(0, potentialStart);
        int end = Math.min(data.length, potentialEnd);
        double total = 0.0;
        for (int q = start; q < end; ++q) {
            total += data[q];
        }
        return total / (double)(end - start);
    }

    public void doRollingMedian(int window) {
        if ((long)window > 0x7FFFFFF5L || this.internalList.size() > 1) {
            System.err.println("ERROR: NOT YET IMPLEMENTED!!!");
            System.exit(-3);
        }
        QuickMedian.doRollingMedian(this.internalList.get(0), window);
    }
}

