/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.block;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javastraw.reader.block.BlockIndex;
import javastraw.reader.block.IndexEntry;

public class DynamicBlockIndex
extends BlockIndex {
    private final int maxBlocks;
    private final long minPosition;
    private final long maxPosition;
    private Integer blockNumberRangeMin = null;
    private Integer blockNumberRangeMax = null;
    private Long mapFileBoundsMin = null;
    private Long mapFileBoundsMax = null;
    private final SeekableStream stream;

    public DynamicBlockIndex(SeekableStream stream, int numBlocks, int maxBlocks, long minPosition) {
        super(numBlocks);
        this.stream = stream;
        this.maxBlocks = maxBlocks;
        this.minPosition = minPosition;
        this.maxPosition = minPosition + (long)(numBlocks * 16);
    }

    @Override
    public List<Integer> getBlockNumbers() {
        return null;
    }

    @Override
    public IndexEntry getBlock(int blockNumber) {
        if (blockNumber > this.maxBlocks) {
            return null;
        }
        if (this.blockIndex.containsKey(blockNumber)) {
            return (IndexEntry)this.blockIndex.get(blockNumber);
        }
        if (blockNumber == 0) {
            try {
                return this.searchForBlockIndexEntry(blockNumber, this.minPosition, this.minPosition + 16L);
            }
            catch (Exception e) {
                return null;
            }
        }
        long minPosition = this.minPosition;
        long maxPosition = this.maxPosition;
        if (this.blockNumberRangeMin != null && this.mapFileBoundsMin != null) {
            if (blockNumber < this.blockNumberRangeMin) {
                maxPosition = this.mapFileBoundsMin;
            } else if (blockNumber > this.blockNumberRangeMax) {
                minPosition = this.mapFileBoundsMax;
            }
        }
        if (maxPosition - minPosition < 16L) {
            return null;
        }
        try {
            return this.searchForBlockIndexEntry(blockNumber, minPosition, maxPosition);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexEntry searchForBlockIndexEntry(int blockNumber, long boundsMin, long boundsMax) throws IOException {
        int blockSizeInBytes;
        long filePosition;
        int blockNumberFound;
        int chunkSize = 1600000;
        if (boundsMax - boundsMin < (long)chunkSize) {
            SeekableStream seekableStream = this.stream;
            synchronized (seekableStream) {
                this.stream.seek(boundsMin);
                LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(this.stream));
                Integer firstBlockNumber = null;
                Integer lastBlockNumber = null;
                for (long pointer = boundsMin; pointer < boundsMax; pointer += 16L) {
                    int blockNumberFound2 = dis.readInt();
                    long filePosition2 = dis.readLong();
                    int blockSizeInBytes2 = dis.readInt();
                    this.blockIndex.put(blockNumberFound2, new IndexEntry(filePosition2, blockSizeInBytes2));
                    if (firstBlockNumber == null) {
                        firstBlockNumber = blockNumberFound2;
                    }
                    lastBlockNumber = blockNumberFound2;
                }
                this.mapFileBoundsMin = boundsMin;
                this.mapFileBoundsMax = boundsMax;
                this.blockNumberRangeMin = firstBlockNumber;
                this.blockNumberRangeMax = lastBlockNumber;
            }
            return (IndexEntry)this.blockIndex.get(blockNumber);
        }
        int nEntries = (int)((boundsMax - boundsMin) / 16L);
        long positionToSeek = boundsMin + (long)Math.floor((float)nEntries / 2.0f) * 16L;
        SeekableStream seekableStream = this.stream;
        synchronized (seekableStream) {
            this.stream.seek(positionToSeek);
            byte[] buffer = new byte[16];
            this.stream.readFully(buffer);
            LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            blockNumberFound = dis.readInt();
            filePosition = dis.readLong();
            blockSizeInBytes = dis.readInt();
        }
        if (blockNumberFound == blockNumber) {
            this.blockIndex.put(blockNumberFound, new IndexEntry(filePosition, blockSizeInBytes));
            return (IndexEntry)this.blockIndex.get(blockNumber);
        }
        if (blockNumber > blockNumberFound) {
            return this.searchForBlockIndexEntry(blockNumber, positionToSeek + 16L, boundsMax);
        }
        return this.searchForBlockIndexEntry(blockNumber, boundsMin, positionToSeek);
    }
}

