/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.block;

import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javastraw.reader.block.IndexEntry;

public class BlockIndex {
    protected final Map<Integer, IndexEntry> blockIndex;
    protected final int numBlocks;

    public BlockIndex(int nBlocks) {
        this.numBlocks = nBlocks;
        this.blockIndex = new HashMap<Integer, IndexEntry>(nBlocks);
    }

    public void populateBlocks(LittleEndianInputStream dis) throws IOException {
        for (int b = 0; b < this.numBlocks; ++b) {
            int blockNumber = dis.readInt();
            long filePosition = dis.readLong();
            int blockSizeInBytes = dis.readInt();
            this.blockIndex.put(blockNumber, new IndexEntry(filePosition, blockSizeInBytes));
        }
    }

    public List<Integer> getBlockNumbers() {
        return new ArrayList<Integer>(this.blockIndex.keySet());
    }

    public IndexEntry getBlock(int blockNumber) {
        return this.blockIndex.get(blockNumber);
    }
}

