/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.basics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.basics.chrom.sizes.ChromosomeSizes;

public class ChromosomeTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChromosomeHandler loadChromosomes(String idOrFile) {
        InputStream is = null;
        try {
            is = ChromosomeSizes.class.getResourceAsStream(idOrFile + ".chrom.sizes");
            if (is == null) {
                File file = new File(idOrFile);
                try {
                    if (file.exists()) {
                        is = new FileInputStream(file);
                    } else {
                        System.err.println("Could not find chromosome sizes file for: " + idOrFile);
                        System.exit(35);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
            chromosomes.add(0, null);
            Pattern pattern = Pattern.compile("\\s+");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is), 0x200000);
            int idx = 1;
            try {
                String nextLine;
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens2 = pattern.split(nextLine);
                    if (tokens2.length == 2) {
                        String name = tokens2[0];
                        int length = Integer.parseInt(tokens2[1]);
                        chromosomes.add(idx, new Chromosome(idx, name, length));
                        ++idx;
                        continue;
                    }
                    System.out.println("Skipping " + nextLine);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ChromosomeHandler chromosomeHandler = new ChromosomeHandler(chromosomes, idOrFile, false);
            return chromosomeHandler;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

