/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.basics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javastraw.reader.basics.Chromosome;
import org.broad.igv.util.Pair;

public class ChromosomeHandler {
    private static final String GENOMEWIDE_CHR = "GENOMEWIDE";
    public static final int CUSTOM_CHROMOSOME_BUFFER = 10;
    private static final String CHR_ALL = "All";
    private final Map<String, Chromosome> chromosomeMap = new HashMap<String, Chromosome>();
    private final List<Chromosome> cleanedChromosomes;
    private final String genomeID;
    private final int[] chromosomeBoundaries;
    private final Chromosome[] chromosomesArray;
    private final Chromosome[] chromosomeArrayWithoutAllByAll;
    private final Chromosome[] chromosomeArrayAutosomesOnly;

    public ChromosomeHandler(List<Chromosome> chromosomes, String genomeID) {
        this(chromosomes, genomeID, true);
    }

    public ChromosomeHandler(List<Chromosome> chromosomes, String genomeID, boolean setAllChr) {
        this.genomeID = genomeID;
        if (setAllChr) {
            long genomeLength = this.getTotalLengthOfAllChromosomes(chromosomes);
            chromosomes.set(0, new Chromosome(0, this.cleanUpName(CHR_ALL), (int)(genomeLength / 1000L)));
        }
        this.cleanedChromosomes = this.initializeCleanedChromosomesList(chromosomes);
        Pair<int[], List<Chromosome[]>> outputs = this.initializeInternalVariables();
        this.chromosomeBoundaries = outputs.getFirst();
        this.chromosomesArray = outputs.getSecond().get(0);
        this.chromosomeArrayWithoutAllByAll = outputs.getSecond().get(1);
        this.chromosomeArrayAutosomesOnly = outputs.getSecond().get(2);
    }

    public static boolean isAllByAll(String name) {
        return name.toLowerCase().contains("all");
    }

    public static void sort(List<Chromosome> indices) {
        indices.sort(new ChromosomeComparator());
    }

    private static Set<Chromosome> getSetIntersection(Collection<Chromosome> collection1, Collection<Chromosome> collection2) {
        HashSet<Chromosome> set1 = new HashSet<Chromosome>(collection1);
        HashSet<Chromosome> set2 = new HashSet<Chromosome>(collection2);
        boolean set1IsLarger = set1.size() > set2.size();
        HashSet<Chromosome> cloneSet = new HashSet<Chromosome>(set1IsLarger ? set2 : set1);
        cloneSet.retainAll(set1IsLarger ? set1 : set2);
        return cloneSet;
    }

    public static boolean isAllByAll(Chromosome chromosome) {
        return ChromosomeHandler.isAllByAll(chromosome.getName());
    }

    public String cleanUpName(String name) {
        if (name.equalsIgnoreCase("assembly")) {
            return "assembly";
        }
        if (name.equalsIgnoreCase("pseudoassembly")) {
            return "pseudoassembly";
        }
        if (this.genomeID.equalsIgnoreCase("hg19") || this.genomeID.equalsIgnoreCase("hg38")) {
            return name.trim().toLowerCase().replaceAll("chr", "").toUpperCase();
        }
        return name;
    }

    private boolean isGenomeWide(Chromosome chromosome) {
        return this.isGenomeWide(chromosome.getName());
    }

    private boolean isGenomeWide(String name) {
        return this.cleanUpName(name).equalsIgnoreCase(GENOMEWIDE_CHR);
    }

    public Chromosome generateAssemblyChromosome() {
        int size = (int)this.getTotalLengthOfAllChromosomes(Arrays.asList(this.chromosomeArrayWithoutAllByAll));
        int newIndex = this.cleanedChromosomes.size();
        Chromosome newChr = new Chromosome(newIndex, "pseudoassembly", size);
        this.cleanedChromosomes.add(newChr);
        this.chromosomeMap.put(newChr.getName(), newChr);
        return newChr;
    }

    private List<Chromosome> initializeCleanedChromosomesList(List<Chromosome> chromosomes) {
        ArrayList<Chromosome> cleanedChromosomes = new ArrayList<Chromosome>();
        for (Chromosome c : chromosomes) {
            if (c == null) continue;
            String cleanName = this.cleanUpName(c.getName());
            Chromosome cleanChromosome = new Chromosome(c.getIndex(), cleanName, c.getLength());
            cleanedChromosomes.add(cleanChromosome);
        }
        return cleanedChromosomes;
    }

    private Pair<int[], List<Chromosome[]>> initializeInternalVariables() {
        for (Chromosome c : this.cleanedChromosomes) {
            this.chromosomeMap.put(c.getName(), c);
            if (!c.getName().equalsIgnoreCase("MT")) continue;
            this.chromosomeMap.put("M", c);
        }
        int[] chromosomeBoundaries = new int[this.cleanedChromosomes.size() - 1];
        long bound = 0L;
        for (int i = 1; i < this.cleanedChromosomes.size(); ++i) {
            Chromosome c = this.cleanedChromosomes.get(i);
            chromosomeBoundaries[i - 1] = (int)(bound += c.getLength() / 1000L);
        }
        Chromosome[] chromosomesArray = this.cleanedChromosomes.toArray(new Chromosome[this.cleanedChromosomes.size()]);
        Chromosome[] chromosomeArrayWithoutAllByAll = new Chromosome[chromosomesArray.length - 1];
        System.arraycopy(chromosomesArray, 1, chromosomeArrayWithoutAllByAll, 0, chromosomesArray.length - 1);
        ArrayList<Chromosome> autosomes = new ArrayList<Chromosome>();
        for (Chromosome chr : chromosomeArrayWithoutAllByAll) {
            if (chr.getName().toLowerCase().contains("x") || chr.getName().toLowerCase().contains("y") || chr.getName().toLowerCase().contains("m")) continue;
            autosomes.add(chr);
        }
        Chromosome[] chromosomeArrayAutosomesOnly = new Chromosome[autosomes.size()];
        for (int i = 0; i < autosomes.size(); ++i) {
            chromosomeArrayAutosomesOnly[i] = (Chromosome)autosomes.get(i);
        }
        ArrayList<Chromosome[]> outputs = new ArrayList<Chromosome[]>();
        outputs.add(chromosomesArray);
        outputs.add(chromosomeArrayWithoutAllByAll);
        outputs.add(chromosomeArrayAutosomesOnly);
        return new Pair<int[], List<Chromosome[]>>(chromosomeBoundaries, outputs);
    }

    private long getTotalLengthOfAllChromosomes(List<Chromosome> chromosomes) {
        long genomeLength = 0L;
        for (Chromosome c : chromosomes) {
            if (c == null) continue;
            genomeLength += c.getLength();
        }
        return genomeLength;
    }

    public String getGenomeID() {
        return this.genomeID;
    }

    public int getMaxChromIndex() {
        int maxChromIndex = 0;
        for (Chromosome chrom : this.chromosomesArray) {
            maxChromIndex = Math.max(maxChromIndex, chrom.getIndex());
        }
        return maxChromIndex;
    }

    public Chromosome getChromosomeFromName(String name) {
        return this.chromosomeMap.get(this.cleanUpName(name));
    }

    public boolean doesNotContainChromosome(String name) {
        return !this.chromosomeMap.containsKey(this.cleanUpName(name));
    }

    public int size() {
        return this.chromosomesArray.length;
    }

    public int[] getChromosomeBoundaries() {
        return this.chromosomeBoundaries;
    }

    public Chromosome[] getChromosomeArray() {
        return this.chromosomesArray;
    }

    public Chromosome getChromosomeFromIndex(int indx) {
        return this.chromosomesArray[indx];
    }

    public ChromosomeHandler getIntersectionWith(ChromosomeHandler handler2) {
        Set<Chromosome> intersection = ChromosomeHandler.getSetIntersection(this.cleanedChromosomes, handler2.cleanedChromosomes);
        if (intersection.isEmpty()) {
            return null;
        }
        ArrayList<Chromosome> newSetOfChrs = new ArrayList<Chromosome>();
        long genomeLength = this.getTotalLengthOfAllChromosomes(this.cleanedChromosomes);
        newSetOfChrs.add(new Chromosome(0, CHR_ALL, (int)(genomeLength / 1000L)));
        for (Chromosome chromosome : this.cleanedChromosomes) {
            if (ChromosomeHandler.isAllByAll(chromosome) || !intersection.contains(chromosome)) continue;
            newSetOfChrs.add(chromosome);
        }
        return new ChromosomeHandler(newSetOfChrs, this.genomeID, false);
    }

    public Chromosome[] getAutosomalChromosomesArray() {
        return this.chromosomeArrayAutosomesOnly;
    }

    public Chromosome[] getChromosomeArrayWithoutAllByAll() {
        return this.chromosomeArrayWithoutAllByAll;
    }

    public Chromosome[] extractOddOrEvenAutosomes(boolean extractOdd) {
        ArrayList<Chromosome> subset = new ArrayList<Chromosome>();
        for (Chromosome chromosome : this.chromosomeArrayAutosomesOnly) {
            if (extractOdd && chromosome.getIndex() % 2 == 1) {
                subset.add(chromosome);
                continue;
            }
            if (extractOdd || chromosome.getIndex() % 2 != 0) continue;
            subset.add(chromosome);
        }
        Chromosome[] subsetArray = new Chromosome[subset.size()];
        for (int i = 0; i < subset.size(); ++i) {
            subsetArray[i] = (Chromosome)subset.get(i);
        }
        return subsetArray;
    }

    public Pair<Chromosome[], Chromosome[]> splitAutosomesIntoHalves() {
        int n = this.chromosomeArrayAutosomesOnly.length;
        int autosomesLength = 0;
        for (Chromosome chrom : this.chromosomeArrayAutosomesOnly) {
            autosomesLength = (int)((long)autosomesLength + chrom.getLength());
        }
        int halfLength = autosomesLength / 2;
        int firstBatchUpToChr = n / 3 + 1;
        long prevLength = 0L;
        for (int i = 0; i < n / 2; ++i) {
            long newLength = prevLength + this.chromosomeArrayAutosomesOnly[i].getLength();
            if (prevLength <= (long)halfLength && newLength >= (long)halfLength) {
                if (Math.abs(prevLength - (long)halfLength) < Math.abs(newLength - (long)halfLength)) {
                    firstBatchUpToChr = i - 1;
                    break;
                }
                firstBatchUpToChr = i;
                break;
            }
            prevLength = newLength;
        }
        System.out.println("Splitting chromosomes; " + this.chromosomeArrayAutosomesOnly[0].getName() + " to " + this.chromosomeArrayAutosomesOnly[firstBatchUpToChr].getName() + " and " + this.chromosomeArrayAutosomesOnly[firstBatchUpToChr + 1].getName() + " to " + this.chromosomeArrayAutosomesOnly[n - 1].getName());
        Chromosome[] rowsChromosomes = new Chromosome[firstBatchUpToChr];
        Chromosome[] colsChromosomes = new Chromosome[n - firstBatchUpToChr];
        for (int i = 0; i < n; ++i) {
            if (i < firstBatchUpToChr) {
                rowsChromosomes[i] = this.chromosomeArrayAutosomesOnly[i];
                continue;
            }
            colsChromosomes[i - firstBatchUpToChr] = this.chromosomeArrayAutosomesOnly[i];
        }
        return new Pair<Chromosome[], Chromosome[]>(rowsChromosomes, colsChromosomes);
    }

    public Pair<Chromosome[], Chromosome[]> splitAutosomesAndSkipByTwos() {
        int n = this.chromosomeArrayAutosomesOnly.length;
        ArrayList<Chromosome> part1 = new ArrayList<Chromosome>();
        ArrayList<Chromosome> part2 = new ArrayList<Chromosome>();
        part1.add(this.chromosomeArrayAutosomesOnly[0]);
        int counterOffset = 0;
        boolean addToFirstOne = false;
        for (int i = 1; i < n; ++i) {
            if (addToFirstOne) {
                part1.add(this.chromosomeArrayAutosomesOnly[i]);
                continue;
            }
            part2.add(this.chromosomeArrayAutosomesOnly[i]);
            if (++counterOffset != 2) continue;
            addToFirstOne = !addToFirstOne;
            counterOffset = 0;
        }
        return new Pair<Chromosome[], Chromosome[]>(this.chromosomeListToArray(part1), this.chromosomeListToArray(part2));
    }

    private Chromosome[] chromosomeListToArray(List<Chromosome> chromosomes) {
        Chromosome[] array = new Chromosome[chromosomes.size()];
        for (int i = 0; i < chromosomes.size(); ++i) {
            array[i] = chromosomes.get(i);
        }
        return array;
    }

    static class ChromosomeComparator
    implements Comparator<Chromosome> {
        ChromosomeComparator() {
        }

        @Override
        public int compare(Chromosome a, Chromosome b) {
            Integer aIndx = a.getIndex();
            Integer bIndx = b.getIndex();
            return aIndx.compareTo(bIndx);
        }
    }
}

