/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.mzd.DynamicMatrixZoomData;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import org.broad.igv.util.Pair;

public class Matrix {
    private final int chr1;
    private final int chr2;
    private static final Set<Pair<Integer, Integer>> dynamicZoomResolutions = new HashSet<Pair<Integer, Integer>>();
    protected final List<MatrixZoomData> bpZoomData = new ArrayList<MatrixZoomData>();
    protected final List<MatrixZoomData> fragZoomData = new ArrayList<MatrixZoomData>();
    protected final List<MatrixZoomData> dynamicBPZoomData = new ArrayList<MatrixZoomData>();
    private final Comparator<MatrixZoomData> comparator = (o1, o2) -> o2.getBinSize() - o1.getBinSize();

    public Matrix(int chr1, int chr2, List<MatrixZoomData> zoomDataList) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.initZoomDataMap(zoomDataList);
    }

    private void initZoomDataMap(List<MatrixZoomData> zoomDataList) {
        for (MatrixZoomData matrixZoomData : zoomDataList) {
            if (matrixZoomData.getZoom().getUnit() == HiCZoom.HiCUnit.BP) {
                this.bpZoomData.add(matrixZoomData);
            } else {
                this.fragZoomData.add(matrixZoomData);
            }
            this.bpZoomData.sort(this.comparator);
            this.fragZoomData.sort(this.comparator);
        }
        for (Pair pair : dynamicZoomResolutions) {
            try {
                this.createDynamicResolutionMZD(pair, false);
            }
            catch (Exception e) {
                System.err.println("Dynamic resolution could not be made");
            }
        }
        this.dynamicBPZoomData.sort(this.comparator);
    }

    public static String generateKey(int chr1, int chr2) {
        if (chr2 < chr1) {
            return "" + chr2 + "_" + chr1;
        }
        return "" + chr1 + "_" + chr2;
    }

    public void createDynamicResolutionMZD(Pair<Integer, Integer> resPair, boolean addToSet) {
        int newRes = resPair.getFirst();
        int highRes = resPair.getSecond();
        MatrixZoomData highMZD = this.getZoomData(new HiCZoom(HiCZoom.HiCUnit.BP, highRes));
        DynamicMatrixZoomData newMZD = new DynamicMatrixZoomData(new HiCZoom(HiCZoom.HiCUnit.BP, newRes), highMZD);
        if (addToSet) {
            dynamicZoomResolutions.add(resPair);
        }
        this.dynamicBPZoomData.add(newMZD);
    }

    public static String generateKey(Chromosome chr1, Chromosome chr2) {
        int t1 = Math.min(chr1.getIndex(), chr2.getIndex());
        int t2 = Math.max(chr1.getIndex(), chr2.getIndex());
        return Matrix.generateKey(t1, t2);
    }

    public String getKey() {
        return Matrix.generateKey(this.chr1, this.chr2);
    }

    public MatrixZoomData getFirstZoomData() {
        if (this.bpZoomData != null && this.bpZoomData.size() > 0) {
            return this.getFirstZoomData(HiCZoom.HiCUnit.BP);
        }
        return this.getFirstZoomData(HiCZoom.HiCUnit.FRAG);
    }

    public MatrixZoomData getFirstZoomData(HiCZoom.HiCUnit unit) {
        if (unit == HiCZoom.HiCUnit.BP) {
            return this.bpZoomData != null && this.bpZoomData.size() > 0 ? this.bpZoomData.get(0) : null;
        }
        return this.fragZoomData != null && this.fragZoomData.size() > 0 ? this.fragZoomData.get(0) : null;
    }

    public MatrixZoomData getFirstPearsonZoomData(HiCZoom.HiCUnit unit) {
        if (unit == HiCZoom.HiCUnit.BP) {
            return this.bpZoomData != null ? this.bpZoomData.get(2) : null;
        }
        return this.fragZoomData != null ? this.fragZoomData.get(2) : null;
    }

    public MatrixZoomData getZoomData(HiCZoom zoom) {
        int targetZoom = zoom.getBinSize();
        List<MatrixZoomData> zdList = zoom.getUnit() == HiCZoom.HiCUnit.BP ? this.bpZoomData : this.fragZoomData;
        for (MatrixZoomData zd : zdList) {
            if (zd.getBinSize() != targetZoom) continue;
            return zd;
        }
        for (MatrixZoomData zd : this.dynamicBPZoomData) {
            if (zd.getBinSize() != targetZoom) continue;
            return zd;
        }
        if (this.chr1 == 0 && this.chr2 == 0) {
            MatrixZoomData closestValue = zdList.get(0);
            int distance = Math.abs(closestValue.getBinSize() - targetZoom);
            for (MatrixZoomData zd : zdList) {
                int cdistance = Math.abs(zd.getBinSize() - targetZoom);
                if (cdistance >= distance) continue;
                closestValue = zd;
                distance = cdistance;
            }
            return closestValue;
        }
        return null;
    }

    public int getNumberOfZooms(HiCZoom.HiCUnit unit) {
        return unit == HiCZoom.HiCUnit.BP ? this.bpZoomData.size() : this.fragZoomData.size();
    }

    public boolean isNotIntra() {
        return this.chr1 != this.chr2;
    }

    public void clearCache() {
        for (MatrixZoomData mzd : this.bpZoomData) {
            try {
                mzd.clearCache();
            }
            catch (Exception exception) {}
        }
        for (MatrixZoomData mzd : this.fragZoomData) {
            try {
                mzd.clearCache();
            }
            catch (Exception exception) {}
        }
        for (MatrixZoomData mzd : this.dynamicBPZoomData) {
            try {
                mzd.clearCache();
            }
            catch (Exception exception) {}
        }
    }
}

