/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javastraw.StrawGlobals;
import javastraw.reader.AbstractDatasetReader;
import javastraw.reader.Dataset;
import javastraw.reader.Matrix;
import javastraw.reader.ReaderTools;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.Block;
import javastraw.reader.block.BlockIndex;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.block.IndexEntry;
import javastraw.reader.block.LargeIndexEntry;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.norm.NormalizationVector;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;
import org.broad.igv.exceptions.HttpResponseException;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ParsingUtils;

public class DatasetReaderV2
extends AbstractDatasetReader {
    private final Map<String, int[]> fragmentSitesCache = new HashMap<String, int[]>();
    private final Map<String, IndexEntry> masterIndex = Collections.synchronizedMap(new HashMap());
    private Map<String, LargeIndexEntry> normVectorIndex;
    private final Dataset dataset;
    private int version = -1;
    private Map<String, FragIndexEntry> fragmentSitesIndex;
    private final Map<String, BlockIndex> blockIndexMap = Collections.synchronizedMap(new HashMap());
    private long masterIndexPos;
    private long normVectorFilePosition;
    private boolean activeStatus = true;
    public static double[] globalTimeDiffThings = new double[5];
    private final boolean useCache;
    private long nviHeaderPosition;

    public DatasetReaderV2(String path, boolean useCache) {
        super(path);
        this.useCache = useCache;
        this.dataset = new Dataset(this);
    }

    @Override
    public Dataset read() throws IOException {
        try {
            SeekableStream stream = ReaderTools.getValidStream(this.path);
            long position = 0L;
            LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(stream, 0x200000));
            String magicString = dis.readString();
            position += (long)(magicString.length() + 1);
            if (!magicString.equals("HIC")) {
                throw new IOException("Magic string is not HIC, this does not appear to be a hic file.");
            }
            this.version = dis.readInt();
            position += 4L;
            System.out.println("HiC file version: " + this.version);
            this.masterIndexPos = dis.readLong();
            position += 8L;
            String genomeId = dis.readString();
            position += (long)(genomeId.length() + 1);
            if (this.version > 8) {
                this.nviHeaderPosition = position;
                long nvi = dis.readLong();
                long nviSize = dis.readLong();
                System.err.println(nvi + " " + nviSize);
                position += 16L;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (this.version > 4) {
                int nAttributes = dis.readInt();
                position += 4L;
                for (int i = 0; i < nAttributes; ++i) {
                    String key = dis.readString();
                    position += (long)(key.length() + 1);
                    String value = dis.readString();
                    position += (long)(value.length() + 1);
                    attributes.put(key, value);
                }
            }
            this.dataset.setAttributes(attributes);
            int nchrs = dis.readInt();
            position += 4L;
            ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>(nchrs);
            for (int i = 0; i < nchrs; ++i) {
                long size;
                String name = dis.readString();
                position += (long)(name.length() + 1);
                if (this.version > 8) {
                    size = dis.readLong();
                    position += 8L;
                } else {
                    size = dis.readInt();
                    position += 4L;
                }
                chromosomes.add(new Chromosome(i, name, size));
            }
            ChromosomeHandler chromosomeHandler = new ChromosomeHandler(chromosomes, genomeId, false);
            this.dataset.setChromosomeHandler(chromosomeHandler);
            String genomeId1 = chromosomeHandler.getGenomeID();
            this.dataset.setGenomeId(genomeId1);
            int nBpResolutions = dis.readInt();
            position += 4L;
            int[] bpBinSizes = new int[nBpResolutions];
            for (int i = 0; i < nBpResolutions; ++i) {
                bpBinSizes[i] = dis.readInt();
                position += 4L;
            }
            this.dataset.setBpZooms(bpBinSizes);
            int nFragResolutions = dis.readInt();
            position += 4L;
            int[] fragBinSizes = new int[nFragResolutions];
            for (int i = 0; i < nFragResolutions; ++i) {
                fragBinSizes[i] = dis.readInt();
                position += 4L;
            }
            this.dataset.setFragZooms(fragBinSizes);
            dis = null;
            if (nFragResolutions > 0) {
                stream.seek(position);
                this.fragmentSitesIndex = new HashMap<String, FragIndexEntry>();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                String firstChrName = null;
                for (int i = 0; i < nchrs; ++i) {
                    String chr = ((Chromosome)chromosomes.get(i)).getName();
                    if (!chr.equals("All")) {
                        firstChrName = chr;
                    }
                    byte[] buffer = new byte[4];
                    stream.readFully(buffer);
                    int nSites = new LittleEndianInputStream(new ByteArrayInputStream(buffer)).readInt();
                    FragIndexEntry entry = new FragIndexEntry(position += 4L, nSites);
                    this.fragmentSitesIndex.put(chr, entry);
                    map.put(chr, nSites);
                    stream.skip((long)nSites * 4L);
                    position += (long)nSites * 4L;
                }
                this.dataset.setFragmentCounts(map);
            }
            this.readFooter(this.masterIndexPos);
            stream.close();
        }
        catch (IOException e) {
            System.err.println("Error reading dataset : " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStats() throws IOException {
        String stats;
        String statsFileName = this.path.substring(0, this.path.lastIndexOf(46)) + "_stats.html";
        try (BufferedReader reader = null;){
            String nextLine;
            StringBuilder builder = new StringBuilder();
            reader = ParsingUtils.openBufferedReader(statsFileName);
            for (int count = 0; (nextLine = reader.readLine()) != null && count < 1000; ++count) {
                builder.append(nextLine);
                builder.append("\n");
            }
            stats = builder.toString();
        }
        return stats;
    }

    @Override
    public NormalizationVector getNormalizationVector(int chr1Idx, HiCZoom zoom, NormalizationType normalizationType) {
        return this.dataset.getNormalizationVector(chr1Idx, zoom, normalizationType);
    }

    @Override
    public int getDepthBase() {
        return this.dataset.getDepthBase();
    }

    private String checkGraphs(String graphs) {
        boolean reset = false;
        if (graphs == null) {
            reset = true;
        } else {
            Scanner scanner = new Scanner(graphs);
            try {
                int idx;
                while (!scanner.next().equals("[")) {
                }
                for (idx = 0; idx < 2000; ++idx) {
                    scanner.nextLong();
                }
                while (!scanner.next().equals("[")) {
                }
                for (idx = 0; idx < 201; ++idx) {
                    scanner.nextInt();
                    scanner.nextInt();
                    scanner.nextInt();
                }
                while (!scanner.next().equals("[")) {
                }
                for (idx = 0; idx < 100; ++idx) {
                    scanner.nextInt();
                    scanner.nextInt();
                    scanner.nextInt();
                    scanner.nextInt();
                }
            }
            catch (NoSuchElementException exception) {
                reset = true;
            }
        }
        return graphs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readGraphs(String graphFileName) throws IOException {
        try (BufferedReader reader = ParsingUtils.openBufferedReader(graphFileName);){
            String nextLine;
            if (reader == null) {
                String string = null;
                return string;
            }
            StringBuilder builder = new StringBuilder();
            while ((nextLine = reader.readLine()) != null) {
                builder.append(nextLine);
                builder.append("\n");
            }
            String graphs = builder.toString();
            return graphs;
        }
        catch (IOException e) {
            System.err.println("Error while reading graphs file: " + e);
            return null;
        }
    }

    @Override
    public boolean isActive() {
        return this.activeStatus;
    }

    @Override
    public void setActive(boolean status) {
        this.activeStatus = status;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public long getNviHeaderPosition() {
        return this.nviHeaderPosition;
    }

    private void readFooter(long position) throws IOException {
        long currentPosition = this.version > 8 ? this.determineNormVectorFilePosition(8, position) : this.determineNormVectorFilePosition(4, position);
        currentPosition = this.populateMasterIndex(currentPosition);
        currentPosition = this.readExpectedValuesMapForNone(currentPosition);
        if (this.version >= 6) {
            int nNormExpectedValueVectors;
            currentPosition = this.normVectorFilePosition;
            SeekableStream stream = ReaderTools.getValidStream(this.path);
            stream.seek(currentPosition);
            LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(stream, 0x200000));
            try {
                nNormExpectedValueVectors = dis.readInt();
                currentPosition += 4L;
            }
            catch (EOFException | HttpResponseException e) {
                if (StrawGlobals.printVerboseComments) {
                    System.out.println("No normalization vectors");
                }
                return;
            }
            for (int i = 0; i < nNormExpectedValueVectors; ++i) {
                stream.seek(currentPosition);
                dis = new LittleEndianInputStream(new BufferedInputStream(stream, 0x200000));
                String typeString = dis.readString();
                NormalizationType norm = this.dataset.getNormalizationHandler().getNormTypeFromString(typeString);
                currentPosition += (long)(typeString.length() + 1);
                currentPosition = ReaderTools.readExpectedVectorInFooter(currentPosition, this.dataset.getExpectedValueFunctionMap(), norm, this.version, this.path, this);
            }
            if (StrawGlobals.printVerboseComments) {
                System.out.println("NVI " + currentPosition);
            }
            stream.seek(currentPosition);
            dis = new LittleEndianInputStream(new BufferedInputStream(stream, 0x200000));
            int nNormVectors = dis.readInt();
            this.normVectorIndex = new HashMap<String, LargeIndexEntry>(nNormVectors * 2);
            for (int i = 0; i < nNormVectors; ++i) {
                NormalizationType type = this.dataset.getNormalizationHandler().getNormTypeFromString(dis.readString());
                int chrIdx = dis.readInt();
                String unit = dis.readString();
                int resolution = dis.readInt();
                long filePosition = dis.readLong();
                long sizeInBytes = this.version > 8 ? dis.readLong() : (long)dis.readInt();
                String key = NormalizationVector.getKey(type, chrIdx, unit, resolution);
                this.dataset.addNormalizationType(type);
                this.normVectorIndex.put(key, new LargeIndexEntry(filePosition, sizeInBytes));
            }
            stream.close();
        }
    }

    private long readExpectedValuesMapForNone(long currentPosition) throws IOException {
        LinkedHashMap<String, ExpectedValueFunction> expectedValuesMap = new LinkedHashMap<String, ExpectedValueFunction>();
        SeekableStream stream = ReaderTools.getValidStream(this.path);
        stream.seek(currentPosition);
        LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(stream, 0x200000));
        int nExpectedValues = dis.readInt();
        currentPosition += 4L;
        for (int i = 0; i < nExpectedValues; ++i) {
            NormalizationType norm = NormalizationHandler.NONE;
            currentPosition = ReaderTools.readExpectedVectorInFooter(currentPosition, expectedValuesMap, norm, this.version, this.path, this);
        }
        this.dataset.setExpectedValueFunctionMap(expectedValuesMap);
        stream.close();
        return currentPosition;
    }

    private long populateMasterIndex(long currentPosition) throws IOException {
        SeekableStream stream = ReaderTools.getValidStream(this.path);
        stream.seek(currentPosition);
        LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(stream, 0x200000));
        int nEntries = dis.readInt();
        currentPosition += 4L;
        for (int i = 0; i < nEntries; ++i) {
            String key = dis.readString();
            currentPosition += (long)(key.length() + 1);
            long filePosition = dis.readLong();
            int sizeInBytes = dis.readInt();
            currentPosition += 12L;
            this.masterIndex.put(key, new IndexEntry(filePosition, sizeInBytes));
        }
        stream.close();
        return currentPosition;
    }

    private long determineNormVectorFilePosition(int numBytesInVar, long position) throws IOException {
        SeekableStream stream = ReaderTools.getValidStream(this.path);
        stream.seek(position);
        byte[] buffer = new byte[numBytesInVar];
        int actualBytes = stream.read(buffer);
        if (numBytesInVar == actualBytes) {
            LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            long nBytes = numBytesInVar == 4 ? (long)dis.readInt() : dis.readLong();
            this.normVectorFilePosition = this.masterIndexPos + nBytes + (long)numBytesInVar;
        } else {
            System.err.println("Actually read " + actualBytes + " bytes instead of " + numBytesInVar);
            System.exit(10);
        }
        stream.close();
        return position + (long)actualBytes;
    }

    @Override
    public Matrix readMatrix(String key) throws IOException {
        IndexEntry idx = this.masterIndex.get(key);
        if (idx == null) {
            return null;
        }
        byte[] buffer = ReaderTools.seekAndFullyReadCompressedBytes(idx, this.path);
        LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int c1 = dis.readInt();
        int c2 = dis.readInt();
        if (c1 < 0 || c1 > this.dataset.getChromosomeHandler().getChromosomeArray().length || c2 < 0 || c2 > this.dataset.getChromosomeHandler().getChromosomeArray().length) {
            System.err.println("WEIRD BUG HAPPENED AGAIN!!");
            return null;
        }
        Chromosome chr1 = this.dataset.getChromosomeHandler().getChromosomeFromIndex(c1);
        Chromosome chr2 = this.dataset.getChromosomeHandler().getChromosomeFromIndex(c2);
        int nResolutions = dis.readInt();
        long currentFilePosition = idx.position + 12L;
        ArrayList<MatrixZoomData> zdList = new ArrayList<MatrixZoomData>();
        int[] chr1Sites = this.retrieveFragmentSitesFromCache(chr1);
        int[] chr2Sites = this.retrieveFragmentSitesFromCache(chr2);
        for (int i = 0; i < nResolutions; ++i) {
            try {
                Pair<MatrixZoomData, Long> result = ReaderTools.readMatrixZoomData(chr1, chr2, chr1Sites, chr2Sites, currentFilePosition, this.path, this.useCache, this.blockIndexMap, this);
                zdList.add(result.getFirst());
                currentFilePosition = result.getSecond();
                continue;
            }
            catch (Exception ee) {
                System.err.println("Weird error happened with trying to read MZD at currentFilePosition: " + currentFilePosition);
                ee.printStackTrace();
            }
        }
        return new Matrix(c1, c2, zdList);
    }

    int getFragCount(Chromosome chromosome) {
        FragIndexEntry entry = null;
        if (this.fragmentSitesIndex != null) {
            entry = this.fragmentSitesIndex.get(chromosome.getName());
        }
        if (entry != null) {
            return entry.nSites;
        }
        return -1;
    }

    private synchronized int[] retrieveFragmentSitesFromCache(Chromosome chromosome) throws IOException {
        int[] chrSites = this.fragmentSitesCache.get(chromosome.getName());
        if (chrSites == null && this.fragmentSitesIndex != null) {
            FragIndexEntry entry = this.fragmentSitesIndex.get(chromosome.getName());
            if (entry != null && entry.nSites > 0) {
                chrSites = ReaderTools.readSites(entry.position, entry.nSites, this.path);
            }
            this.fragmentSitesCache.put(chromosome.getName(), chrSites);
        }
        return chrSites;
    }

    @Override
    public List<Integer> getBlockNumbers(MatrixZoomData zd) {
        BlockIndex blockIndex = this.blockIndexMap.get(zd.getKey());
        return blockIndex == null ? null : blockIndex.getBlockNumbers();
    }

    public Map<String, LargeIndexEntry> getNormVectorIndex() {
        return this.normVectorIndex;
    }

    public long getNormFilePosition() {
        return this.version <= 5 ? new File(this.path).length() : this.normVectorFilePosition;
    }

    @Override
    public NormalizationVector readNormalizationVector(NormalizationType type, int chrIdx, HiCZoom.HiCUnit unit, int binSize) throws IOException {
        String key = NormalizationVector.getKey(type, chrIdx, unit.toString(), binSize);
        if (this.normVectorIndex == null) {
            return null;
        }
        LargeIndexEntry idx = this.normVectorIndex.get(key);
        boolean useVCForVCSQRT = false;
        if (idx == null && type.equals(NormalizationHandler.VC_SQRT)) {
            key = NormalizationVector.getKey(NormalizationHandler.VC, chrIdx, unit.toString(), binSize);
            idx = this.normVectorIndex.get(key);
            useVCForVCSQRT = true;
        }
        if (idx == null) {
            return null;
        }
        LittleEndianInputStream dis = ReaderTools.createStreamFromSeveralBuffers(idx, this.path);
        long nValues = this.version > 8 ? dis.readLong() : (long)dis.readInt();
        return ReaderTools.createNormalizationVector(type, chrIdx, unit, binSize, useVCForVCSQRT, dis, nValues, this.version);
    }

    @Override
    public NormalizationVector readNormalizationVectorPart(NormalizationType type, int chrIdx, HiCZoom.HiCUnit unit, int binSize, int bound1, int bound2) throws IOException {
        String key = NormalizationVector.getKey(type, chrIdx, unit.toString(), binSize);
        if (this.normVectorIndex == null) {
            return null;
        }
        LargeIndexEntry idx = this.normVectorIndex.get(key);
        boolean useVCForVCSQRT = false;
        if (idx == null && type.equals(NormalizationHandler.VC_SQRT)) {
            key = NormalizationVector.getKey(NormalizationHandler.VC, chrIdx, unit.toString(), binSize);
            idx = this.normVectorIndex.get(key);
            useVCForVCSQRT = true;
        }
        if (idx == null) {
            return null;
        }
        long partPosition = this.version > 8 ? idx.position + 8L + 4L * (long)bound1 : idx.position + 4L + 8L * (long)bound1;
        long partSize = this.version > 8 ? (long)(bound2 - bound1 + 1) * 4L : (long)(bound2 - bound1 + 1) * 8L;
        LittleEndianInputStream dis = ReaderTools.createStreamFromSeveralBuffers(new LargeIndexEntry(partPosition, partSize), this.path);
        long nValues = bound2 - bound1 + 1;
        return ReaderTools.createNormalizationVector(type, chrIdx, unit, binSize, useVCForVCSQRT, dis, nValues, this.version);
    }

    @Override
    public ListOfDoubleArrays readExpectedVectorPart(long position, long nVals) throws IOException {
        long size = this.version > 8 ? nVals * 4L : nVals * 8L;
        LargeIndexEntry idx = new LargeIndexEntry(position, size);
        LittleEndianInputStream dis = ReaderTools.createStreamFromSeveralBuffers(idx, this.path);
        ListOfDoubleArrays values2 = new ListOfDoubleArrays(nVals);
        int i = 0;
        while ((long)i < nVals) {
            double val = this.version > 8 ? (double)dis.readFloat() : dis.readDouble();
            values2.set(i, val);
            ++i;
        }
        return values2;
    }

    @Override
    public Block readNormalizedBlock(int blockNumber, MatrixZoomData zd, NormalizationType no) throws IOException {
        if (no == null) {
            throw new IOException("Norm " + no + " is null");
        }
        if (no.equals(NormalizationHandler.NONE)) {
            return this.readBlock(blockNumber, zd);
        }
        long[] timeDiffThings = new long[4];
        timeDiffThings[0] = System.currentTimeMillis();
        NormalizationVector nv1 = this.dataset.getNormalizationVector(zd.getChr1Idx(), zd.getZoom(), no);
        NormalizationVector nv2 = this.dataset.getNormalizationVector(zd.getChr2Idx(), zd.getZoom(), no);
        if (nv1 == null || nv2 == null) {
            if (StrawGlobals.printVerboseComments) {
                System.err.println("Norm " + no + " missing for: " + zd.getDescription());
                System.err.println(nv1 + " - " + nv2);
            }
            return null;
        }
        ListOfDoubleArrays nv1Data = nv1.getData();
        ListOfDoubleArrays nv2Data = nv2.getData();
        timeDiffThings[1] = System.currentTimeMillis();
        Block rawBlock = this.readBlock(blockNumber, zd);
        timeDiffThings[2] = System.currentTimeMillis();
        if (rawBlock == null) {
            return null;
        }
        List<ContactRecord> records = rawBlock.getContactRecords();
        ArrayList<ContactRecord> normRecords = new ArrayList<ContactRecord>(records.size());
        for (ContactRecord rec : records) {
            int x = rec.getBinX();
            int y = rec.getBinY();
            double denominator = nv1Data.get(x) * nv2Data.get(y);
            float counts = (float)((double)rec.getCounts() / denominator);
            if (Float.isNaN(counts)) continue;
            normRecords.add(new ContactRecord(x, y, counts));
        }
        timeDiffThings[3] = System.currentTimeMillis();
        return new Block(blockNumber, normRecords, zd.getBlockKey(blockNumber, no));
    }

    private Block readBlock(int blockNumber, MatrixZoomData zd) throws IOException {
        IndexEntry idx;
        long[] timeDiffThings = new long[6];
        timeDiffThings[0] = System.currentTimeMillis();
        Block b = null;
        BlockIndex blockIndex = this.blockIndexMap.get(zd.getKey());
        if (blockIndex != null && (idx = blockIndex.getBlock(blockNumber)) != null) {
            byte[] buffer;
            timeDiffThings[1] = System.currentTimeMillis();
            byte[] compressedBytes = ReaderTools.seekAndFullyReadCompressedBytes(idx, this.path);
            timeDiffThings[2] = System.currentTimeMillis();
            try {
                buffer = ReaderTools.decompress(compressedBytes);
                timeDiffThings[3] = System.currentTimeMillis();
            }
            catch (Exception e) {
                throw new RuntimeException("Block read error: " + e.getMessage());
            }
            LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            int nRecords = dis.readInt();
            ArrayList<ContactRecord> records = new ArrayList<ContactRecord>(nRecords);
            timeDiffThings[4] = System.currentTimeMillis();
            if (this.version < 7) {
                for (int i = 0; i < nRecords; ++i) {
                    int binX = dis.readInt();
                    int binY = dis.readInt();
                    float counts = dis.readFloat();
                    records.add(new ContactRecord(binX, binY, counts));
                }
            } else {
                int binXOffset = dis.readInt();
                int binYOffset = dis.readInt();
                boolean useShort = dis.readByte() == 0;
                boolean useShortBinX = true;
                boolean useShortBinY = true;
                if (this.version > 8) {
                    useShortBinX = dis.readByte() == 0;
                    useShortBinY = dis.readByte() == 0;
                }
                byte type = dis.readByte();
                switch (type) {
                    case 1: {
                        int binY;
                        int i;
                        int rowCount;
                        if (useShortBinX && useShortBinY) {
                            rowCount = dis.readShort();
                            for (i = 0; i < rowCount; ++i) {
                                binY = binYOffset + dis.readShort();
                                ReaderTools.populateContactRecordsColShort(dis, records, binXOffset, useShort, binY);
                            }
                        } else if (useShortBinX) {
                            rowCount = dis.readInt();
                            for (i = 0; i < rowCount; ++i) {
                                binY = binYOffset + dis.readInt();
                                ReaderTools.populateContactRecordsColShort(dis, records, binXOffset, useShort, binY);
                            }
                        } else if (useShortBinY) {
                            rowCount = dis.readShort();
                            for (i = 0; i < rowCount; ++i) {
                                binY = binYOffset + dis.readShort();
                                ReaderTools.populateContactRecordsColInt(dis, records, binXOffset, useShort, binY);
                            }
                        } else {
                            rowCount = dis.readInt();
                            for (i = 0; i < rowCount; ++i) {
                                binY = binYOffset + dis.readInt();
                                ReaderTools.populateContactRecordsColInt(dis, records, binXOffset, useShort, binY);
                            }
                        }
                        break;
                    }
                    case 2: {
                        int nPts = dis.readInt();
                        short w = dis.readShort();
                        for (int i = 0; i < nPts; ++i) {
                            int row = i / w;
                            int col = i - row * w;
                            int bin1 = binXOffset + col;
                            int bin2 = binYOffset + row;
                            if (useShort) {
                                short counts = dis.readShort();
                                if (counts == Short.MIN_VALUE) continue;
                                records.add(new ContactRecord(bin1, bin2, counts));
                                continue;
                            }
                            float counts = dis.readFloat();
                            if (Float.isNaN(counts)) continue;
                            records.add(new ContactRecord(bin1, bin2, counts));
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown block type: " + type);
                    }
                }
            }
            b = new Block(blockNumber, records, zd.getBlockKey(blockNumber, NormalizationHandler.NONE));
            timeDiffThings[5] = System.currentTimeMillis();
            for (int ii = 0; ii < timeDiffThings.length - 1; ++ii) {
                int n = ii;
                globalTimeDiffThings[n] = globalTimeDiffThings[n] + (double)(timeDiffThings[ii + 1] - timeDiffThings[ii]) / 1000.0;
            }
        }
        if (b == null) {
            b = new Block(blockNumber, zd.getBlockKey(blockNumber, NormalizationHandler.NONE));
        }
        return b;
    }

    static class FragIndexEntry {
        final long position;
        final int nSites;

        FragIndexEntry(long position, int nSites) {
            this.position = position;
            this.nSites = nSites;
        }
    }
}

