/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javastraw.reader.DatasetReader;
import javastraw.reader.Matrix;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.norm.NormalizationVector;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;
import org.broad.igv.util.Pair;
import org.broad.igv.util.collections.LRUCache;

public class Dataset {
    public static final String V9_DEPTH_BASE = "v9-depth-base";
    public static final int DEFAULT_V9_DEPTH_BASE = 2;
    public static final String HIC_FILE_SCALING = "hicFileScalingFactor";
    public static final String STATISTICS = "statistics";
    public static final String GRAPHS = "graphs";
    public static final String SOFTWARE = "software";
    public static final String NVI_INDEX = "nviIndex";
    public static final String NVI_LENGTH = "nviLength";
    private final Map<String, Matrix> matrices = new HashMap<String, Matrix>(625);
    private final DatasetReader reader;
    private final LRUCache<String, double[]> eigenvectorCache;
    private final LRUCache<String, NormalizationVector> normalizationVectorCache;
    private final String restrictionEnzyme;
    protected String genomeId;
    protected List<HiCZoom> bpZooms;
    protected List<HiCZoom> dynamicZooms;
    protected List<HiCZoom> fragZooms;
    private Map<String, ExpectedValueFunction> expectedValueFunctionMap = null;
    private int v9DepthBase = 0;
    private List<Integer> bpZoomResolutions;
    private Map<String, String> attributes;
    private Map<String, Integer> fragmentCounts;
    protected NormalizationHandler normalizationHandler = new NormalizationHandler();
    private List<NormalizationType> normalizationTypes;
    private ChromosomeHandler chromosomeHandler;

    public Dataset(DatasetReader reader) {
        this.restrictionEnzyme = null;
        this.reader = reader;
        this.eigenvectorCache = new LRUCache(25);
        this.normalizationVectorCache = new LRUCache(25);
        this.normalizationTypes = new ArrayList<NormalizationType>();
    }

    public void clearCache() {
        for (Matrix matrix : this.matrices.values()) {
            try {
                matrix.clearCache();
            }
            catch (Exception exception) {}
        }
        this.eigenvectorCache.clear();
        this.normalizationVectorCache.clear();
        this.normalizationTypes.clear();
    }

    public Matrix getMatrix(Chromosome chr1, Chromosome chr2) {
        if (chr1 == null || chr2 == null) {
            return null;
        }
        String key = Matrix.generateKey(chr1, chr2);
        Matrix m = this.matrices.get(key);
        if (m == null && this.reader != null) {
            try {
                m = this.reader.readMatrix(key);
                this.matrices.put(key, m);
            }
            catch (Exception e) {
                System.err.println("Error fetching matrix for: " + chr1.getName() + "-" + chr2.getName());
                e.printStackTrace();
            }
        }
        return m;
    }

    public void addDynamicResolution(int newRes) {
        int highRes = -1;
        Iterator<Object> iterator2 = this.bpZoomResolutions.iterator();
        while (iterator2.hasNext()) {
            int potentialRes = iterator2.next();
            if (potentialRes >= newRes || potentialRes <= highRes || newRes % potentialRes != 0) continue;
            highRes = potentialRes;
        }
        if (highRes < 0) {
            System.err.println("No suitable higher resolution found");
            return;
        }
        for (Matrix matrix : this.matrices.values()) {
            matrix.createDynamicResolutionMZD(new Pair<Integer, Integer>(newRes, highRes), true);
        }
        this.dynamicZooms.add(new HiCZoom(HiCZoom.HiCUnit.BP, newRes));
    }

    public void setAttributes(Map<String, String> map) {
        this.attributes = map;
        try {
            this.v9DepthBase = Integer.parseInt(this.attributes.get(V9_DEPTH_BASE));
        }
        catch (Exception e) {
            this.v9DepthBase = 0;
        }
    }

    public List<NormalizationType> getNormalizationTypes() {
        return this.normalizationTypes;
    }

    public Map<String, NormalizationType> getNormalizationTypesMap() {
        HashMap<String, NormalizationType> normsForDatasetMap = new HashMap<String, NormalizationType>();
        for (NormalizationType nType : this.normalizationTypes) {
            normsForDatasetMap.put(nType.getLabel(), nType);
        }
        return normsForDatasetMap;
    }

    public void setNormalizationTypes(List<NormalizationType> normalizationTypes) {
        this.normalizationTypes = normalizationTypes;
    }

    public void addNormalizationType(NormalizationType type) {
        if (!this.normalizationTypes.contains(type)) {
            this.normalizationTypes.add(type);
        }
    }

    public int getNumberZooms(HiCZoom.HiCUnit unit) {
        return unit == HiCZoom.HiCUnit.BP ? this.bpZooms.size() + this.dynamicZooms.size() : this.fragZooms.size();
    }

    public HiCZoom getZoom(HiCZoom.HiCUnit unit, int index) {
        return unit == HiCZoom.HiCUnit.BP ? this.bpZooms.get(index) : this.fragZooms.get(index);
    }

    public HiCZoom getZoomForBPResolution(Integer resolution) {
        for (HiCZoom zoom : this.bpZooms) {
            if (zoom.getBinSize() != resolution.intValue()) continue;
            return zoom;
        }
        for (HiCZoom zoom : this.dynamicZooms) {
            if (zoom.getBinSize() != resolution.intValue()) continue;
            return zoom;
        }
        return null;
    }

    public ExpectedValueFunction getExpectedValues(HiCZoom zoom, NormalizationType type, boolean getCorrectedVersion) {
        if (this.expectedValueFunctionMap == null || zoom == null || type == null) {
            return null;
        }
        if (getCorrectedVersion) {
            return this.getCustomCorrectedExpectedValues(zoom, type, 5000000);
        }
        String key = ExpectedValueFunction.getKey(zoom, type, false, 0);
        return this.expectedValueFunctionMap.get(key);
    }

    public ExpectedValueFunction getCustomCorrectedExpectedValues(HiCZoom zoom, NormalizationType type, int window) {
        if (this.expectedValueFunctionMap == null || zoom == null || type == null) {
            return null;
        }
        return this.getCorrectedVersionOfExpectedVector(zoom, type, window);
    }

    private ExpectedValueFunction getCorrectedVersionOfExpectedVector(HiCZoom zoom, NormalizationType type, int window) {
        String key = ExpectedValueFunction.getKey(zoom, type, true, window);
        if (!this.expectedValueFunctionMap.containsKey(key)) {
            String normalKey = ExpectedValueFunction.getKey(zoom, type, false, window);
            ExpectedValueFunction normalEVF = this.expectedValueFunctionMap.get(normalKey);
            if (normalEVF == null) {
                return null;
            }
            this.expectedValueFunctionMap.put(key, normalEVF.getCorrectedVersion(window));
        }
        return this.expectedValueFunctionMap.get(key);
    }

    public ExpectedValueFunction getExpectedValuesOrExit(HiCZoom zoom, NormalizationType type, Chromosome chromosome, boolean isIntra, boolean getCorrectedVersion) {
        ExpectedValueFunction df = this.getExpectedValues(zoom, type, getCorrectedVersion);
        if (isIntra && df == null) {
            System.err.println("O/E data not available at " + chromosome.getName() + " " + zoom + " " + type);
            System.exit(14);
        }
        return df;
    }

    public Map<String, ExpectedValueFunction> getExpectedValueFunctionMap() {
        return this.expectedValueFunctionMap;
    }

    public void setExpectedValueFunctionMap(Map<String, ExpectedValueFunction> df) {
        this.expectedValueFunctionMap = df;
    }

    public ChromosomeHandler getChromosomeHandler() {
        return this.chromosomeHandler;
    }

    public void setChromosomeHandler(ChromosomeHandler chromosomeHandler) {
        this.chromosomeHandler = chromosomeHandler;
    }

    public int getVersion() {
        return this.reader.getVersion();
    }

    public String getGenomeId() {
        return this.genomeId;
    }

    public void setGenomeId(String genomeId) {
        if (genomeId.equals("GRCm38")) {
            genomeId = "mm10";
        }
        this.genomeId = genomeId;
    }

    public String getSoftware() {
        if (this.attributes != null) {
            return this.attributes.get(SOFTWARE);
        }
        return null;
    }

    public String getHiCFileScalingFactor() {
        if (this.attributes != null) {
            return this.attributes.get(HIC_FILE_SCALING);
        }
        return null;
    }

    public String getStatistics() {
        String stats = null;
        if (this.attributes != null) {
            stats = this.attributes.get(STATISTICS);
        }
        if (stats == null) {
            try {
                this.attributes.put(STATISTICS, this.reader.readStats());
            }
            catch (IOException error) {
                return null;
            }
        }
        return this.attributes.get(STATISTICS);
    }

    public String getGraphs() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(GRAPHS);
    }

    public List<HiCZoom> getBpZooms() {
        ArrayList<HiCZoom> zooms = new ArrayList<HiCZoom>(this.bpZooms);
        zooms.addAll(this.dynamicZooms);
        zooms.sort(Collections.reverseOrder());
        return zooms;
    }

    public void setBpZooms(int[] bpBinSizes) {
        this.bpZoomResolutions = Ints.asList(bpBinSizes);
        this.bpZooms = new ArrayList<HiCZoom>(bpBinSizes.length);
        for (int bpBinSize : this.bpZoomResolutions) {
            this.bpZooms.add(new HiCZoom(HiCZoom.HiCUnit.BP, bpBinSize));
        }
        this.dynamicZooms = new ArrayList<HiCZoom>();
    }

    public List<HiCZoom> getFragZooms() {
        return this.fragZooms;
    }

    public void setFragZooms(int[] fragBinSizes) {
        this.fragZooms = new ArrayList<HiCZoom>(fragBinSizes.length);
        for (int fragBinSize : fragBinSizes) {
            this.fragZooms.add(new HiCZoom(HiCZoom.HiCUnit.FRAG, fragBinSize));
        }
    }

    public boolean hasFrags() {
        return this.fragZooms != null && this.fragZooms.size() > 0;
    }

    public Map<String, Integer> getFragmentCounts() {
        return this.fragmentCounts;
    }

    public void setFragmentCounts(Map<String, Integer> map) {
        this.fragmentCounts = map;
    }

    public HiCZoom getNextZoom(HiCZoom zoom, boolean useIncreasingOrder) {
        List<HiCZoom> zoomList;
        HiCZoom.HiCUnit currentUnit = zoom.getUnit();
        List<HiCZoom> list = zoomList = currentUnit == HiCZoom.HiCUnit.BP ? this.getBpZooms() : this.fragZooms;
        if (useIncreasingOrder) {
            for (int i = 0; i < zoomList.size() - 1; ++i) {
                if (!zoom.equals(zoomList.get(i))) continue;
                return zoomList.get(i + 1);
            }
            return zoomList.get(zoomList.size() - 1);
        }
        for (int i = zoomList.size() - 1; i > 0; --i) {
            if (!zoom.equals(zoomList.get(i))) continue;
            return zoomList.get(i - 1);
        }
        return zoomList.get(0);
    }

    public NormalizationVector getNormalizationVector(int chrIdx, HiCZoom zoom, NormalizationType type) {
        String key = NormalizationVector.getKey(type, chrIdx, zoom.getUnit().toString(), zoom.getBinSize());
        if (type.equals(NormalizationHandler.NONE)) {
            return null;
        }
        if (!this.normalizationVectorCache.containsKey(key)) {
            try {
                NormalizationVector nv = this.reader.readNormalizationVector(type, chrIdx, zoom.getUnit(), zoom.getBinSize());
                this.normalizationVectorCache.put(key, nv);
            }
            catch (IOException e) {
                this.normalizationVectorCache.put(key, null);
            }
        }
        return this.normalizationVectorCache.get(key);
    }

    public NormalizationVector getPartNormalizationVector(int chrIdx, HiCZoom zoom, NormalizationType type, int bound1, int bound2) {
        NormalizationVector nv;
        String key = NormalizationVector.getKey(type, chrIdx, zoom.getUnit().toString(), zoom.getBinSize());
        if (type.equals(NormalizationHandler.NONE)) {
            return null;
        }
        try {
            nv = this.reader.readNormalizationVectorPart(type, chrIdx, zoom.getUnit(), zoom.getBinSize(), bound1, bound2);
        }
        catch (IOException e) {
            return null;
        }
        return nv;
    }

    public List<HiCZoom> getAllPossibleResolutions() {
        ArrayList<HiCZoom> resolutions = new ArrayList<HiCZoom>();
        resolutions.addAll(this.bpZooms);
        resolutions.addAll(this.dynamicZooms);
        resolutions.addAll(this.fragZooms);
        return resolutions;
    }

    public NormalizationHandler getNormalizationHandler() {
        return this.normalizationHandler;
    }

    public int getDepthBase() {
        return this.v9DepthBase;
    }

    public String getPath() {
        return this.reader.getPath();
    }
}

