/*
 * Decompiled with CFR 0.152.
 */
package javastraw.matrices;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javastraw.matrices.BasicMatrix;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class SymmetricMatrix
implements BasicMatrix {
    private final int dim;
    private final float[] data;
    private final Set<Integer> nullColumns;
    private float lowerValue = Float.NaN;
    private float upperValue = Float.NaN;

    public SymmetricMatrix(int dim) {
        this.dim = dim;
        int size = (dim * dim - dim) / 2 + dim;
        this.data = new float[size];
        this.nullColumns = new HashSet<Integer>();
    }

    public void nullColumn(int i) {
        this.nullColumns.add(i);
    }

    public Set<Integer> getNullColumns() {
        return this.nullColumns;
    }

    public void fill(float value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public void setEntry(int i, int j, float value) {
        this.data[this.getIdx((int)i, (int)j)] = value;
    }

    private int getIdx(int i, int j) {
        return i < j ? i * this.dim - (i - 1) * i / 2 + j - i : j * this.dim - (j - 1) * j / 2 + i - j;
    }

    public float getColumnMean(int j) {
        return this.getRowMean(j);
    }

    public float getRowMean(int i) {
        float sum = 0.0f;
        int count = 0;
        for (int j = 0; j < this.dim; ++j) {
            float value = this.getEntry(i, j);
            if (Float.isNaN(value)) continue;
            sum += value;
            ++count;
        }
        return count == 0 ? Float.NaN : sum / (float)count;
    }

    @Override
    public float getEntry(int i, int j) {
        int idx = this.getIdx(i, j);
        return idx < this.data.length ? this.data[idx] : Float.NaN;
    }

    @Override
    public int getRowDimension() {
        return this.dim;
    }

    @Override
    public int getColumnDimension() {
        return this.dim;
    }

    @Override
    public float getLowerValue() {
        if (Float.isNaN(this.lowerValue)) {
            this.computePercentiles();
        }
        return this.lowerValue;
    }

    @Override
    public float getUpperValue() {
        if (Float.isNaN(this.upperValue)) {
            this.computePercentiles();
        }
        return this.upperValue;
    }

    private void computePercentiles() {
        DescriptiveStatistics flattenedDataStats = new DescriptiveStatistics();
        for (float value : this.data) {
            if (Float.isNaN(value) || value == 1.0f) continue;
            flattenedDataStats.addValue(value);
        }
        this.lowerValue = (float)flattenedDataStats.getPercentile(5.0);
        this.upperValue = (float)flattenedDataStats.getPercentile(95.0);
    }
}

