/*
 * Decompiled with CFR 0.152.
 */
package javastraw.matrices;

import java.util.Collection;
import java.util.HashMap;

class SparseVector {
    private final int length;
    private final HashMap<Integer, Double> values;

    public SparseVector(int length) {
        this.length = length;
        this.values = new HashMap();
    }

    public void set(Integer i, Double v) {
        if (i >= this.length) {
            throw new IndexOutOfBoundsException("Index " + i + " is >= length " + this.length);
        }
        this.values.put(i, v);
    }

    public int getLength() {
        return this.length;
    }

    public Double get(Integer idx) {
        return this.values.getOrDefault(idx, 0.0);
    }

    public Collection<Integer> getIndeces() {
        return this.values.keySet();
    }

    public Double getMean() {
        if (this.values.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (Double v : this.values.values()) {
            sum += v.doubleValue();
        }
        return sum / (double)this.values.size();
    }
}

