/*
 * Decompiled with CFR 0.152.
 */
package javastraw.matrices;

import java.util.Arrays;
import java.util.List;
import javastraw.matrices.BasicMatrix;
import javastraw.reader.block.ContactRecord;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class SparseSymmetricMatrix
implements BasicMatrix {
    private final int numValsEstimate;
    private final IntArrayList rows1;
    private final IntArrayList cols1;
    private final FloatArrayList values1;
    private IntArrayList rows2 = null;
    private IntArrayList cols2 = null;
    private FloatArrayList values2 = null;

    public SparseSymmetricMatrix(int numValsEstimate) {
        this.numValsEstimate = numValsEstimate;
        this.rows1 = new IntArrayList(numValsEstimate);
        this.cols1 = new IntArrayList(numValsEstimate);
        this.values1 = new FloatArrayList(numValsEstimate);
    }

    public void populateMatrix(List<ContactRecord> list, int[] offset) {
        for (ContactRecord cr : list) {
            int x = cr.getBinX();
            int y = cr.getBinY();
            float value = cr.getCounts();
            if (offset[x] == -1 || offset[y] == -1) continue;
            this.setEntry(offset[x], offset[y], value);
        }
    }

    public double[] multiply(double[] vector) {
        double[] result = new double[vector.length];
        Arrays.fill(result, 0.0);
        this.multiplyOverRowsCols(vector, result, this.rows1, this.cols1, this.values1);
        if (this.rows2 != null) {
            this.multiplyOverRowsCols(vector, result, this.rows2, this.cols2, this.values2);
        }
        return result;
    }

    private void multiplyOverRowsCols(double[] vector, double[] result, IntArrayList rows1, IntArrayList cols1, FloatArrayList values1) {
        int[] rowArray1 = rows1.toArray();
        int[] colArray1 = cols1.toArray();
        float[] valueArray1 = values1.toArray();
        int n = rowArray1.length;
        for (int i = 0; i < n; ++i) {
            int row = rowArray1[i];
            int col = colArray1[i];
            float value = valueArray1[i];
            int n2 = row;
            result[n2] = result[n2] + vector[col] * (double)value;
            if (row == col) continue;
            int n3 = col;
            result[n3] = result[n3] + vector[row] * (double)value;
        }
    }

    @Override
    public float getEntry(int row, int col) {
        this.notImplementedDontCall();
        return 0.0f;
    }

    private void notImplementedDontCall() {
        System.err.println("called unimplemented function - terminate");
        System.exit(9);
    }

    @Override
    public int getRowDimension() {
        this.notImplementedDontCall();
        return 0;
    }

    @Override
    public int getColumnDimension() {
        this.notImplementedDontCall();
        return 0;
    }

    @Override
    public float getLowerValue() {
        this.notImplementedDontCall();
        return 0.0f;
    }

    @Override
    public float getUpperValue() {
        this.notImplementedDontCall();
        return 0.0f;
    }

    @Override
    public void setEntry(int row, int col, float val) {
        if (!Float.isNaN(val)) {
            if (this.rows2 == null) {
                try {
                    this.rows1.add(row);
                    this.cols1.add(col);
                    this.values1.add(val);
                }
                catch (NegativeArraySizeException error) {
                    this.rows2 = new IntArrayList(this.numValsEstimate);
                    this.cols2 = new IntArrayList(this.numValsEstimate);
                    this.values2 = new FloatArrayList(this.numValsEstimate);
                    this.rows2.add(row);
                    this.cols2.add(col);
                    this.values2.add(val);
                }
            } else {
                this.rows2.add(row);
                this.cols2.add(col);
                this.values2.add(val);
            }
        }
    }
}

