/*
 * Decompiled with CFR 0.152.
 */
package javastraw.matrices;

import javastraw.matrices.BasicMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class RealMatrixWrapper
implements BasicMatrix {
    private final RealMatrix matrix;
    private float lowerValue = -1.0f;
    private float upperValue = 1.0f;

    public RealMatrixWrapper(RealMatrix matrix) {
        this.matrix = matrix;
        this.computePercentiles();
    }

    @Override
    public float getEntry(int row, int col) {
        return (float)this.matrix.getEntry(row, col);
    }

    @Override
    public int getRowDimension() {
        return this.matrix.getRowDimension();
    }

    @Override
    public int getColumnDimension() {
        return this.matrix.getColumnDimension();
    }

    @Override
    public float getLowerValue() {
        return this.lowerValue;
    }

    @Override
    public float getUpperValue() {
        return this.upperValue;
    }

    @Override
    public void setEntry(int i, int j, float corr) {
    }

    private void computePercentiles() {
        DescriptiveStatistics flattenedDataStats = new DescriptiveStatistics();
        double min = 1.0;
        double max = -1.0;
        for (int i = 0; i < this.matrix.getRowDimension(); ++i) {
            for (int j = 0; j < this.matrix.getColumnDimension(); ++j) {
                double value = this.matrix.getEntry(i, j);
                if (Double.isNaN(value) || value == 1.0) continue;
                min = Math.min(value, min);
                max = Math.max(value, max);
                flattenedDataStats.addValue(value);
            }
        }
        this.lowerValue = (float)flattenedDataStats.getPercentile(5.0);
        this.upperValue = (float)flattenedDataStats.getPercentile(95.0);
    }

    public RealMatrix getMatrix() {
        return this.matrix;
    }
}

