/*
 * Decompiled with CFR 0.152.
 */
package javastraw.matrices;

import java.util.Arrays;
import javastraw.matrices.BasicMatrix;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class InMemoryMatrix
implements BasicMatrix {
    private final int dim;
    private final float[] data;
    private float lowerValue = Float.NaN;
    private float upperValue = Float.NaN;

    public InMemoryMatrix(int dim) {
        this.dim = dim;
        this.data = new float[dim * dim];
    }

    public InMemoryMatrix(int dim, float[] data) {
        this.data = data;
        this.dim = dim;
    }

    public void fill(float value) {
        Arrays.fill(this.data, value);
        this.lowerValue = Float.NaN;
        this.upperValue = Float.NaN;
    }

    @Override
    public float getEntry(int row, int col) {
        int idx = row * this.dim + col;
        return idx < this.data.length ? this.data[idx] : Float.NaN;
    }

    @Override
    public void setEntry(int row, int col, float value) {
        int idx = row * this.dim + col;
        this.data[idx] = value;
        this.lowerValue = Float.NaN;
        this.upperValue = Float.NaN;
    }

    @Override
    public int getRowDimension() {
        return this.dim;
    }

    @Override
    public int getColumnDimension() {
        return this.dim;
    }

    @Override
    public float getLowerValue() {
        if (Float.isNaN(this.lowerValue)) {
            this.computeBounds();
        }
        return this.lowerValue;
    }

    @Override
    public float getUpperValue() {
        if (Float.isNaN(this.upperValue)) {
            this.computeBounds();
        }
        return this.upperValue;
    }

    private void computeBounds() {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (float datum : this.data) {
            if (Float.isNaN(datum)) continue;
            stats.addValue(datum);
        }
        this.lowerValue = (float)stats.getPercentile(5.0);
        this.upperValue = (float)stats.getPercentile(95.0);
    }
}

