/*
 * Decompiled with CFR 0.152.
 */
package javastraw.matrices;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javastraw.matrices.BasicMatrix;
import org.broad.igv.util.ObjectCache;
import org.broad.igv.util.ParsingUtils;

public class DiskResidentBlockMatrix
implements BasicMatrix {
    private final String path;
    private final ObjectCache<String, float[][]> blockDataCache = new ObjectCache(200);
    boolean isLoading = false;
    private String genome;
    private String chr1;
    private String chr2;
    private int binSize;
    private float lowerValue;
    private float upperValue;
    private int dim;
    private int blockSize;
    private int remSize;
    private int arrayStartPosition;
    private int nFullBlocks;

    public DiskResidentBlockMatrix(String path) throws IOException {
        this.path = path;
        this.init();
    }

    public String getChr1() {
        return this.chr1;
    }

    @Override
    public float getEntry(int row, int col) {
        int blockRowIdx = row / this.blockSize;
        int blockColIdx = col / this.blockSize;
        String key = "row" + blockRowIdx + "_col" + blockColIdx;
        float[][] blockData = this.blockDataCache.get(key);
        if (blockData == null) {
            blockData = this.loadBlockData(blockRowIdx, blockColIdx);
            this.blockDataCache.put(key, blockData);
        }
        if (blockData == null) {
            return Float.NaN;
        }
        int rowRelative = row - blockRowIdx * this.blockSize;
        int colRelative = col - blockColIdx * this.blockSize;
        int totalRows = blockData.length;
        int totalCols = blockData[0].length;
        if (rowRelative < totalRows && colRelative < totalCols) {
            return blockData[rowRelative][colRelative];
        }
        return Float.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized float[][] loadBlockData(int blockRowIdx, int blockColIdx) {
        String key = "row" + blockRowIdx + "_col" + blockColIdx;
        float[][] blockData = this.blockDataCache.get(key);
        if (blockData != null) {
            return blockData;
        }
        SeekableStream is = null;
        try {
            is = SeekableStreamFactory.getInstance().getStreamFor(this.path);
            int pointsPerBlockRow = this.blockSize * this.dim;
            int rowDim = blockRowIdx < this.nFullBlocks ? this.blockSize : this.remSize;
            int colDim = blockColIdx < this.nFullBlocks ? this.blockSize : this.remSize;
            int l1 = blockRowIdx * pointsPerBlockRow;
            int l2 = blockColIdx * this.blockSize * rowDim;
            long startFilePosition = (long)this.arrayStartPosition + (long)(l1 + l2) * 4L;
            int nDataPoints = rowDim * colDim;
            int nBytes = nDataPoints * 4;
            byte[] byteArray = new byte[nBytes];
            is.seek(startFilePosition);
            is.readFully(byteArray);
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
            LittleEndianInputStream les = new LittleEndianInputStream(bis);
            blockData = new float[rowDim][colDim];
            for (int r = 0; r < rowDim; ++r) {
                for (int c = 0; c < colDim; ++c) {
                    float f;
                    blockData[r][c] = f = les.readFloat();
                }
            }
            this.blockDataCache.put(key, blockData);
            float[][] fArray = blockData;
            return fArray;
        }
        catch (IOException e) {
            System.err.println("Error reading block data: " + blockRowIdx + "-" + blockColIdx + " " + e.getLocalizedMessage());
            float[][] fArray = null;
            return fArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public int getRowDimension() {
        return this.dim;
    }

    @Override
    public int getColumnDimension() {
        return this.dim;
    }

    @Override
    public float getLowerValue() {
        return this.lowerValue;
    }

    @Override
    public float getUpperValue() {
        return this.upperValue;
    }

    @Override
    public void setEntry(int i, int j, float corr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        try (BufferedInputStream bis = null;){
            InputStream is = ParsingUtils.openInputStream(this.path);
            bis = new BufferedInputStream(is);
            LittleEndianInputStream les = new LittleEndianInputStream(bis);
            int bytePosition = 0;
            int magic = les.readInt();
            bytePosition += 4;
            int version = les.readInt();
            bytePosition += 4;
            this.genome = les.readString();
            bytePosition += this.genome.length() + 1;
            this.chr1 = les.readString();
            bytePosition += this.chr1.length() + 1;
            this.chr2 = les.readString();
            bytePosition += this.chr2.length() + 1;
            this.binSize = les.readInt();
            bytePosition += 4;
            this.lowerValue = les.readFloat();
            bytePosition += 4;
            this.upperValue = les.readFloat();
            bytePosition += 4;
            int nRows = les.readInt();
            bytePosition += 4;
            int nCols = les.readInt();
            bytePosition += 4;
            if (nRows != nCols) {
                throw new RuntimeException("Non-square matrices not supported");
            }
            this.dim = nRows;
            this.blockSize = les.readInt();
            this.nFullBlocks = this.dim / this.blockSize;
            this.remSize = this.dim - this.nFullBlocks * this.blockSize;
            this.arrayStartPosition = bytePosition += 4;
        }
    }
}

