/*
 * Decompiled with CFR 0.152.
 */
package javastraw.feature2D;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javastraw.feature2D.Feature2D;
import javastraw.feature2D.Feature2DFilter;
import javastraw.feature2D.Feature2DList;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import org.broad.igv.Globals;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;

public class Feature2DParser {
    private static final int BUFFER_SIZE = 0x200000;

    public static Feature2DList loadFeatures(String path, ChromosomeHandler handler, boolean loadAttributes, Feature2DFilter featureFilter, final boolean useFeature2DWithMotif) {
        String lowerCaseEnding = path.toLowerCase();
        Feature2DList newList = lowerCaseEnding.endsWith(".bedpe") ? Feature2DParser.parseGeneralFile(path, handler, loadAttributes, featureFilter, new SpecificParser(){

            @Override
            void parseAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType) throws IOException {
                this.parseBEDPEAndAddToList(path, headers, tokens2, lineNum, loadAttributes, nextLine, handler, newList, featureType, useFeature2DWithMotif);
            }
        }) : (lowerCaseEnding.endsWith(".px") ? Feature2DParser.parseGeneralFile(path, handler, loadAttributes, featureFilter, new SpecificParser(){

            @Override
            void parseAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType) throws IOException {
                this.parsePxLoopsAndAddToList(path, headers, tokens2, lineNum, loadAttributes, nextLine, handler, newList, featureType);
            }
        }) : (lowerCaseEnding.endsWith(".px2") ? Feature2DParser.parseGeneralFile(path, handler, loadAttributes, featureFilter, new SpecificParser(){

            @Override
            void parseAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType) throws IOException {
                this.parseDomainsAndAddToList(path, headers, tokens2, lineNum, loadAttributes, nextLine, handler, newList, featureType);
            }
        }) : Feature2DParser.parseGeneralFile(path, handler, loadAttributes, featureFilter, new SpecificParser(){

            @Override
            void parseAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType) throws IOException {
                this.parseLegacyLoopsAndAddToList(path, headers, tokens2, lineNum, loadAttributes, nextLine, handler, newList, featureType, useFeature2DWithMotif);
            }
        })));
        newList.removeDuplicates();
        return newList;
    }

    private static Feature2D.FeatureType parseTitleForFeatureType(String path) {
        if (path.contains("block") || path.contains("domain")) {
            return Feature2D.FeatureType.DOMAIN;
        }
        if (path.contains("peak") || path.contains("loop")) {
            return Feature2D.FeatureType.PEAK;
        }
        return Feature2D.FeatureType.GENERIC;
    }

    private static Feature2DList parseGeneralFile(String path, ChromosomeHandler handler, boolean loadAttributes, Feature2DFilter featureFilter, SpecificParser parser) {
        Feature2DList newList = new Feature2DList();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(path)), 0x200000);
            String nextLine = br.readLine();
            String[] headers = Feature2DParser.getHeaders(nextLine);
            Feature2D.FeatureType featureType = Feature2DParser.parseTitleForFeatureType(path);
            int lineNum = 1;
            while ((nextLine = br.readLine()) != null) {
                ++lineNum;
                if (nextLine.startsWith("#")) continue;
                String[] tokens2 = Globals.tabPattern.split(nextLine);
                if (tokens2.length > headers.length) {
                    String text = "Improperly formatted file: \nLine " + lineNum + " has " + tokens2.length + " entries while header has " + headers.length;
                    System.err.println(text);
                    throw new IOException(text);
                }
                parser.parseAndAddToList(path, headers, tokens2, lineNum, loadAttributes, nextLine, handler, newList, featureType);
            }
            br.close();
        }
        catch (Exception ec) {
            System.err.println("File " + path + " could not be parsed");
        }
        if (featureFilter != null) {
            newList.filterLists(featureFilter);
        }
        return newList;
    }

    private static String[] getHeaders(String line) {
        String[] tmpHeaders = Globals.tabPattern.split(line.replaceAll("#", "").trim());
        String[] headers = new String[tmpHeaders.length];
        block24: for (int i = 0; i < tmpHeaders.length; ++i) {
            switch (tmpHeaders[i]) {
                case "o": {
                    headers[i] = "observed";
                    continue block24;
                }
                case "e_bl": {
                    headers[i] = "expectedBL";
                    continue block24;
                }
                case "e_donut": {
                    headers[i] = "expectedDonut";
                    continue block24;
                }
                case "e_h": {
                    headers[i] = "expectedH";
                    continue block24;
                }
                case "e_v": {
                    headers[i] = "expectedV";
                    continue block24;
                }
                case "fdr_bl": {
                    headers[i] = "fdrBL";
                    continue block24;
                }
                case "fdr_donut": {
                    headers[i] = "fdrDonut";
                    continue block24;
                }
                case "fdr_h": {
                    headers[i] = "fdrH";
                    continue block24;
                }
                case "fdr_v": {
                    headers[i] = "fdrV";
                    continue block24;
                }
                case "num_collapsed": {
                    headers[i] = "numCollapsed";
                    continue block24;
                }
                default: {
                    headers[i] = tmpHeaders[i];
                }
            }
        }
        return headers;
    }

    private static abstract class SpecificParser {
        private static final int errorLimit = 100;
        private static int errorCount = 0;

        SpecificParser() {
            errorCount = 0;
        }

        private static Map<String, String> parseAttributes(boolean loadAttributes, int attCol, String[] headers, String[] tokens2) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            if (loadAttributes && tokens2.length > attCol) {
                for (int i = attCol; i < tokens2.length; ++i) {
                    attrs.put(headers[i], tokens2[i]);
                }
            }
            return attrs;
        }

        private static void addToList(String chr1Name, String chr2Name, ChromosomeHandler handler, String nextLine, Feature2DList newList, boolean useFeature2DWithMotif, Feature2D.FeatureType featureType, int start1, int end1, int start2, int end2, Color c, Map<String, String> attrs) {
            Chromosome chr1 = handler.getChromosomeFromName(chr1Name);
            Chromosome chr2 = handler.getChromosomeFromName(chr2Name);
            if (chr1 == null || chr2 == null) {
                SpecificParser.handleError(nextLine);
                return;
            }
            if (chr1.getIndex() <= chr2.getIndex()) {
                newList.add(chr1.getIndex(), chr2.getIndex(), new Feature2D(featureType, chr1Name, start1, end1, chr2Name, start2, end2, c, attrs));
            } else {
                newList.add(chr2.getIndex(), chr1.getIndex(), new Feature2D(featureType, chr2Name, start2, end2, chr1Name, start1, end1, c, attrs));
            }
        }

        private static void addToList(String chrAName, Feature2D feature, ChromosomeHandler handler, String nextLine, Feature2DList newList) {
            Chromosome chrA = handler.getChromosomeFromName(chrAName);
            if (chrA == null) {
                SpecificParser.handleError(nextLine);
                return;
            }
            newList.add(chrA.getIndex(), chrA.getIndex(), feature);
        }

        private static void handleError(String nextLine) {
            if (errorCount < 100) {
                System.err.println("Skipping line: " + nextLine);
            } else if (errorCount == 100) {
                System.err.println("Maximum error count exceeded.  Further errors will not be logged");
            }
            ++errorCount;
        }

        abstract void parseAndAddToList(String var1, String[] var2, String[] var3, int var4, boolean var5, String var6, ChromosomeHandler var7, Feature2DList var8, Feature2D.FeatureType var9) throws IOException;

        void parseDomainsAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType) throws IOException {
            int endA;
            int startA;
            String chrAName;
            if (tokens2.length < 3) {
                return;
            }
            try {
                chrAName = tokens2[0];
                startA = Integer.parseInt(tokens2[1]);
                endA = Integer.parseInt(tokens2[2]);
            }
            catch (Exception e) {
                String text = "Line " + lineNum + " improperly formatted in <br>" + path + "<br>Line format should start with:  CHR1  X1  X2";
                System.err.println(text);
                throw new IOException(text);
            }
            Color c = Color.black;
            Map<String, String> attrs = SpecificParser.parseAttributes(loadAttributes, 3, headers, tokens2);
            Feature2D feature = new Feature2D(featureType, chrAName, startA, endA, chrAName, startA, endA, c, attrs);
            SpecificParser.addToList(chrAName, feature, handler, nextLine, newList);
        }

        void parseBEDPEAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType, boolean useFeature2DWithMotif) throws IOException {
            int end2;
            int start2;
            String chr2Name;
            int end1;
            int start1;
            String chr1Name;
            if (tokens2.length < 6) {
                return;
            }
            try {
                chr1Name = tokens2[0];
                start1 = Integer.parseInt(tokens2[1]);
                end1 = Integer.parseInt(tokens2[2]);
                chr2Name = tokens2[3];
                start2 = Integer.parseInt(tokens2[4]);
                end2 = Integer.parseInt(tokens2[5]);
            }
            catch (Exception e) {
                String text = "Line " + lineNum + " improperly formatted in <br>" + path + "<br>Line format should start with:  CHR1  X1  X2  CHR2  Y1  Y2";
                System.err.println(text);
                throw new IOException(text);
            }
            Color c = tokens2.length > 10 ? ColorUtilities.stringToColor(tokens2[10].trim()) : Color.black;
            Map<String, String> attrs = SpecificParser.parseAttributes(loadAttributes, 11, headers, tokens2);
            SpecificParser.addToList(chr1Name, chr2Name, handler, nextLine, newList, useFeature2DWithMotif, featureType, start1, end1, start2, end2, c, attrs);
        }

        void parseLegacyLoopsAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType, boolean useFeature2DWithMotif) throws IOException {
            int end2;
            int start2;
            String chr2Name;
            int end1;
            int start1;
            String chr1Name;
            if (tokens2.length < 6) {
                return;
            }
            try {
                chr1Name = tokens2[0];
                start1 = Integer.parseInt(tokens2[1]);
                end1 = Integer.parseInt(tokens2[2]);
                chr2Name = tokens2[3];
                start2 = Integer.parseInt(tokens2[4]);
                end2 = Integer.parseInt(tokens2[5]);
            }
            catch (Exception e) {
                String text = "Line " + lineNum + " improperly formatted in <br>" + path + "<br>Line format should start with:  CHR1  X1  X2  CHR2  Y1  Y2";
                System.err.println(text);
                throw new IOException(text);
            }
            Color c = tokens2.length > 6 ? ColorUtilities.stringToColor(tokens2[6].trim()) : Color.black;
            Map<String, String> attrs = SpecificParser.parseAttributes(loadAttributes, 7, headers, tokens2);
            SpecificParser.addToList(chr1Name, chr2Name, handler, nextLine, newList, useFeature2DWithMotif, featureType, start1, end1, start2, end2, c, attrs);
        }

        void parsePxLoopsAndAddToList(String path, String[] headers, String[] tokens2, int lineNum, boolean loadAttributes, String nextLine, ChromosomeHandler handler, Feature2DList newList, Feature2D.FeatureType featureType) throws IOException {
            int end2;
            int start2;
            String chr2Name;
            int end1;
            int start1;
            String chr1Name;
            if (tokens2.length < 4) {
                return;
            }
            try {
                chr1Name = tokens2[0];
                start1 = Integer.parseInt(tokens2[1]);
                end1 = start1 + 5000;
                chr2Name = tokens2[2];
                start2 = Integer.parseInt(tokens2[3]);
                end2 = start2 + 5000;
            }
            catch (Exception e) {
                String text = "Line " + lineNum + " improperly formatted in <br>" + path + "<br>Line format should start with:  CHR1  X1  CHR2  Y1";
                System.err.println(text);
                throw new IOException(text);
            }
            Color c = tokens2.length > 4 ? ColorUtilities.stringToColor(tokens2[4].trim()) : Color.black;
            Map<String, String> attrs = SpecificParser.parseAttributes(loadAttributes, 5, headers, tokens2);
            SpecificParser.addToList(chr1Name, chr2Name, handler, nextLine, newList, false, featureType, start1, end1, start2, end2, c, attrs);
        }
    }
}

