/*
 * Decompiled with CFR 0.152.
 */
package javastraw.feature2D;

import java.awt.Color;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javastraw.feature2D.Feature2D;
import javastraw.feature2D.Feature2DFilter;
import javastraw.feature2D.Feature2DFunction;
import javastraw.reader.basics.Chromosome;
import javastraw.tools.HiCFileTools;

public class Feature2DList {
    private final Map<String, List<Feature2D>> featureList = new HashMap<String, List<Feature2D>>();
    private Map<String, String> defaultAttributes = new HashMap<String, String>();

    public Feature2DList() {
    }

    public Feature2DList(Feature2DList list) {
        this.add(list);
        this.defaultAttributes.putAll(list.defaultAttributes);
    }

    public static String getKey(int chr1Idx, int chr2Idx) {
        int c2;
        int c1;
        if (chr1Idx < chr2Idx) {
            c1 = chr1Idx;
            c2 = chr2Idx;
        } else {
            c1 = chr2Idx;
            c2 = chr1Idx;
        }
        return "" + c1 + "_" + c2;
    }

    public static String getKey(Chromosome chr1, Chromosome chr2) {
        return Feature2DList.getKey(chr1.getIndex(), chr2.getIndex());
    }

    public static Feature2DList getIntersection(final Feature2DList listA, Feature2DList listB) {
        Feature2DList commonFeatures = new Feature2DList(listB);
        commonFeatures.filterLists(new Feature2DFilter(){

            @Override
            public List<Feature2D> filter(String chr, List<Feature2D> feature2DList) {
                ArrayList<Feature2D> commonVals = new ArrayList<Feature2D>();
                if (listA.containsKey(chr)) {
                    List<Feature2D> listAFeatures = listA.getFeatureList(chr);
                    for (Feature2D feature : listAFeatures) {
                        if (!feature2DList.contains(feature)) continue;
                        commonVals.add(feature);
                    }
                }
                return commonVals;
            }
        });
        commonFeatures.removeDuplicates();
        return commonFeatures;
    }

    private static synchronized void addAllUnique(List<Feature2D> inputFeatures, List<Feature2D> existingFeatures) {
        for (Feature2D inputFeature : inputFeatures) {
            if (Feature2DList.doesOverlap(inputFeature, existingFeatures)) continue;
            existingFeatures.add(inputFeature);
        }
    }

    public static boolean doesOverlap(Feature2D feature, List<Feature2D> existingFeatures) {
        boolean repeat = false;
        for (Feature2D existingFeature : existingFeatures) {
            if (!existingFeature.overlapsWith(feature)) continue;
            repeat = true;
        }
        return repeat;
    }

    public void parallelizedProcessLists(final Feature2DFunction featureFunction) {
        ArrayList<String> keys2 = new ArrayList<String>(this.featureList.keySet());
        Collections.sort(keys2);
        ExecutorService executor = Executors.newFixedThreadPool(keys2.size());
        for (final String key : keys2) {
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    featureFunction.process(key, (List)Feature2DList.this.featureList.get(key));
                }
            };
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
    }

    public synchronized void filterLists(Feature2DFilter filter) {
        ArrayList<String> keys2 = new ArrayList<String>(this.featureList.keySet());
        Collections.sort(keys2);
        for (String key : keys2) {
            this.featureList.put(key, filter.filter(key, this.featureList.get(key)));
        }
    }

    public List<Feature2D> get(int chr1Idx, int chr2Idx) {
        String key = Feature2DList.getKey(chr1Idx, chr2Idx);
        if (!this.featureList.containsKey(key)) {
            ArrayList features = new ArrayList();
            this.featureList.put(key, features);
        }
        return this.featureList.get(key);
    }

    public List<Feature2D> get(String key) {
        if (!this.featureList.containsKey(key)) {
            ArrayList features = new ArrayList();
            this.featureList.put(key, features);
        }
        return this.featureList.get(key);
    }

    public synchronized void add(int chr1Idx, int chr2Idx, Feature2D feature) {
        String key = Feature2DList.getKey(chr1Idx, chr2Idx);
        this.addByKey(key, feature);
    }

    public synchronized void addByKey(String key, Feature2D feature) {
        feature = this.updateAttributeForFeature(feature);
        if (this.featureList.containsKey(key)) {
            this.featureList.get(key).add(feature);
        } else {
            ArrayList<Feature2D> loops = new ArrayList<Feature2D>();
            loops.add(feature);
            this.featureList.put(key, loops);
        }
    }

    public synchronized void addByKey(String key, List<Feature2D> features) {
        features = this.updateAttributes(features);
        if (this.featureList.containsKey(key)) {
            this.featureList.get(key).addAll(features);
        } else {
            ArrayList<Feature2D> loops = new ArrayList<Feature2D>(features);
            this.featureList.put(key, loops);
        }
    }

    private synchronized Feature2D updateAttributeForFeature(Feature2D feature) {
        block4: {
            if (this.defaultAttributes == null) break block4;
            if (feature.getAttributeKeys() == null) {
                for (String attribute : this.defaultAttributes.keySet()) {
                    feature.addStringAttribute(attribute, this.defaultAttributes.get(attribute));
                    System.out.println("Added:1 " + attribute);
                }
            } else {
                ArrayList<String> featureKeys = feature.getAttributeKeys();
                for (String customKey : this.defaultAttributes.keySet()) {
                    if (featureKeys.contains(customKey)) continue;
                    feature.addStringAttribute(customKey, this.defaultAttributes.get(customKey));
                }
            }
        }
        return feature;
    }

    private synchronized List<Feature2D> updateAttributes(List<Feature2D> features) {
        this.processLists(new Feature2DFunction(){

            @Override
            public void process(String chr, List<Feature2D> feature2DList) {
                for (Feature2D feature : feature2DList) {
                    Feature2DList.this.updateAttributeForFeature(feature);
                }
            }
        });
        return features;
    }

    private synchronized void putFeature(String key, List<Feature2D> loops) {
        this.featureList.put(key, loops);
    }

    public boolean exportFeatureList(File outputFile, boolean formattedOutput, ListFormat listFormat) {
        if (this.featureList != null && this.featureList.size() > 0) {
            PrintWriter outputFilePrintWriter = HiCFileTools.openWriter(outputFile);
            if (this.exportFeatureList(outputFilePrintWriter, formattedOutput, listFormat)) {
                System.out.println(this.getNumTotalFeatures() + " features written to file: " + outputFile.getAbsolutePath());
            } else {
                System.err.println("Error features not written to file: " + outputFile.getAbsolutePath());
            }
        }
        return false;
    }

    private boolean exportFeatureList(final PrintWriter outputFilePrintWriter, boolean formattedOutput, ListFormat listFormat) {
        if (this.featureList != null && this.featureList.size() > 0) {
            Feature2D featureZero = this.extractSingleFeature();
            if (featureZero != null) {
                outputFilePrintWriter.println(featureZero.getOutputFileHeader());
                this.processLists(new Feature2DFunction(){

                    @Override
                    public void process(String chr, List<Feature2D> feature2DList) {
                        Collections.sort(feature2DList);
                        for (Feature2D feature : feature2DList) {
                            outputFilePrintWriter.println(feature);
                        }
                    }
                });
            }
            outputFilePrintWriter.close();
            return true;
        }
        return false;
    }

    public void autoSaveNew(PrintWriter outputFile, Feature2D feature) {
        if (this.featureList != null && this.featureList.size() > 0) {
            outputFile.println(feature);
        }
    }

    public void autoSaveAll(PrintWriter outputFile) {
        if (this.featureList != null && this.featureList.size() > 0) {
            for (String key : this.featureList.keySet()) {
                for (Feature2D feature : this.featureList.get(key)) {
                    outputFile.println(feature);
                }
            }
        }
    }

    public Feature2D extractSingleFeature() {
        for (List<Feature2D> features : this.featureList.values()) {
            Iterator<Feature2D> iterator2 = features.iterator();
            if (!iterator2.hasNext()) continue;
            Feature2D feature = iterator2.next();
            return feature;
        }
        return null;
    }

    public void setColor(final Color color) {
        this.processLists(new Feature2DFunction(){

            @Override
            public void process(String chr, List<Feature2D> feature2DList) {
                for (Feature2D feature : feature2DList) {
                    feature.setColor(color);
                }
            }
        });
    }

    public synchronized void add(Feature2DList inputList) {
        Set<String> inputKeySet = inputList.getKeySet();
        for (String inputKey : inputKeySet) {
            List<Feature2D> inputFeatures = inputList.getFeatureList(inputKey);
            if (this.featureList.containsKey(inputKey)) {
                this.featureList.get(inputKey).addAll(inputFeatures);
                continue;
            }
            ArrayList<Feature2D> features = new ArrayList<Feature2D>(inputFeatures);
            this.putFeature(inputKey, features);
        }
    }

    public synchronized void addUnique(Feature2DList inputList) {
        Set<String> inputKeySet = inputList.getKeySet();
        for (String inputKey : inputKeySet) {
            List<Feature2D> inputFeatures = inputList.getFeatureList(inputKey);
            if (this.featureList.containsKey(inputKey)) {
                Feature2DList.addAllUnique(inputFeatures, this.featureList.get(inputKey));
                continue;
            }
            ArrayList<Feature2D> features = new ArrayList<Feature2D>(inputFeatures);
            this.putFeature(inputKey, features);
        }
    }

    public Feature2DList getOverlap(Feature2DList inputList) {
        Feature2DList output = new Feature2DList();
        Set<String> inputKeySet = inputList.getKeySet();
        for (String inputKey : inputKeySet) {
            List<Feature2D> inputFeatures = inputList.getFeatureList(inputKey);
            if (!this.featureList.containsKey(inputKey)) continue;
            for (Feature2D myFeature : this.featureList.get(inputKey)) {
                if (!Feature2DList.doesOverlap(myFeature, inputFeatures)) continue;
                output.addByKey(inputKey, myFeature);
            }
        }
        return output;
    }

    public synchronized void setDefaultAttributes(Map<String, String> defaultAttributes) {
        this.defaultAttributes = defaultAttributes;
    }

    public synchronized void addDefaultAttribute(String attribute, String value) {
        this.defaultAttributes.put(attribute, value);
        this.addAttributeFieldToAll(attribute, value);
    }

    public synchronized void addAttributeFieldToAll(final String newAttributeName, final String newAttributeValue) {
        this.processLists(new Feature2DFunction(){

            @Override
            public void process(String chr, List<Feature2D> feature2DList) {
                for (Feature2D feature : feature2DList) {
                    if (!feature.doesNotContainAttributeKey(newAttributeName)) continue;
                    feature.addStringAttribute(newAttributeName, newAttributeValue);
                }
            }
        });
    }

    public void removeDuplicates() {
        this.filterLists(new Feature2DFilter(){

            @Override
            public List<Feature2D> filter(String chr, List<Feature2D> feature2DList) {
                return new ArrayList<Feature2D>(new HashSet<Feature2D>(feature2DList));
            }
        });
    }

    private Set<String> getKeySet() {
        return this.featureList.keySet();
    }

    public List<Feature2D> getFeatureList(String key) {
        return this.featureList.get(key);
    }

    public synchronized void processLists(Feature2DFunction function) {
        ArrayList<String> keys2 = new ArrayList<String>(this.featureList.keySet());
        Collections.sort(keys2);
        for (String key : keys2) {
            function.process(key, this.featureList.get(key));
        }
    }

    public boolean containsKey(String key) {
        return this.featureList.containsKey(key);
    }

    public int getIndex(Chromosome chrX, Chromosome chrY, Feature2D feature2D) {
        String key = Feature2DList.getKey(chrX, chrY);
        List<Feature2D> contigs = this.get(key);
        for (int i = 0; i < contigs.size(); ++i) {
            Feature2D currentContig = contigs.get(i);
            if (!currentContig.equals(feature2D)) continue;
            return i;
        }
        return -1;
    }

    public int getNumTotalFeatures() {
        int total = 0;
        for (List<Feature2D> chrList : this.featureList.values()) {
            total += chrList.size();
        }
        return total;
    }

    public synchronized boolean checkAndRemoveFeature(int idx1, int idx2, Feature2D feature) {
        boolean somethingWasDeleted = false;
        String key = Feature2DList.getKey(idx1, idx2);
        if (this.featureList.containsKey(key)) {
            try {
                somethingWasDeleted = this.featureList.get(key).remove(feature);
            }
            catch (Exception e) {
                System.err.println("Error encountered removing feature");
            }
            if (this.featureList.get(key).size() == 0) {
                this.featureList.remove(key);
            }
        }
        return somethingWasDeleted;
    }

    public Feature2D searchForFeature(final int c1, final int start1, final int end1, final int c2, final int start2, final int end2) {
        final Feature2D[] feature = new Feature2D[1];
        this.processLists(new Feature2DFunction(){

            @Override
            public void process(String chr, List<Feature2D> feature2DList) {
                for (Feature2D f : feature2DList) {
                    if (!f.getChr1().contains("" + c1) || !f.getChr2().contains("" + c2) || f.start1 != (long)start1 || f.start2 != (long)start2 || f.end1 != (long)end1 || f.end2 != (long)end2) continue;
                    feature[0] = f;
                    break;
                }
            }
        });
        return feature[0];
    }

    public void clearAllAttributes() {
        this.processLists(new Feature2DFunction(){

            @Override
            public void process(String chr, List<Feature2D> feature2DList) {
                for (Feature2D feature : feature2DList) {
                    feature.clearAttributes();
                }
            }
        });
    }

    public Feature2DList deepCopy() {
        Feature2DList clone = new Feature2DList();
        for (String key : this.featureList.keySet()) {
            ArrayList<Feature2D> cloneList = new ArrayList<Feature2D>();
            for (Feature2D f : this.featureList.get(key)) {
                cloneList.add(f.deepCopy());
            }
            clone.featureList.put(key, cloneList);
        }
        return clone;
    }

    public String printChromosomeRegionKeys() {
        StringBuilder features = new StringBuilder();
        for (List<Feature2D> feature2DS : this.featureList.values()) {
            for (Feature2D feature2D : feature2DS) {
                features.append(feature2D.getLocationKey()).append(", ");
            }
        }
        return features.toString();
    }

    public static enum ListFormat {
        ENRICHED,
        FINAL,
        ARROWHEAD,
        NA;

    }
}

