/*
 * Decompiled with CFR 0.152.
 */
package javastraw.feature2D;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Feature2D
implements Comparable<Feature2D> {
    public static final String genericHeader = "#chr1\tx1\tx2\tchr2\ty1\ty2\tname\tscore\tstrand1\tstrand2\tcolor";
    private static final String BEDPE_SPACER = "\t.\t.\t.\t.";
    public static int tolerance = 0;
    protected final FeatureType featureType;
    protected final Map<String, String> attributes;
    protected final String chr1;
    protected final String chr2;
    protected final long start1;
    protected final long start2;
    protected long end1;
    protected long end2;
    protected Feature2D reflection = null;
    protected Color color;
    protected boolean status = false;

    public Feature2D(FeatureType featureType, String chr1, long start1, long end1, String chr2, long start2, long end2, Color c, Map<String, String> attributes) {
        this.featureType = featureType;
        this.chr1 = chr1;
        this.start1 = start1;
        this.end1 = end1;
        this.chr2 = chr2;
        this.start2 = start2;
        this.end2 = end2;
        this.color = c == null ? Color.black : c;
        this.attributes = attributes;
    }

    public static String getDefaultOutputFileHeader() {
        return genericHeader;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public String getFeatureName() {
        switch (this.featureType) {
            case PEAK: {
                return "Peak";
            }
            case DOMAIN: {
                return "Contact Domain";
            }
        }
        return "Feature";
    }

    public String getChr1() {
        return this.chr1;
    }

    public String getChr2() {
        return this.chr2;
    }

    public long getStart1() {
        return this.start1;
    }

    public long getStart2() {
        return this.start2;
    }

    public long getEnd1() {
        return this.end1;
    }

    public void setEnd1(int end1) {
        this.end1 = end1;
        if (this.reflection != null) {
            this.reflection.end2 = end1;
        }
    }

    public long getEnd2() {
        return this.end2;
    }

    public void setEnd2(int end2) {
        this.end2 = end2;
        if (this.reflection != null) {
            this.reflection.end1 = end2;
        }
    }

    public long getWidth1() {
        return this.end1 - this.start1;
    }

    public long getWidth2() {
        return this.end2 - this.start2;
    }

    public long getMidPt1() {
        return this.midPoint(this.start1, this.end1);
    }

    public long getMidPt2() {
        return this.midPoint(this.start2, this.end2);
    }

    public long midPoint(long start, long end) {
        return (long)((double)start + (double)(end - start) / 2.0);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.reflection != null) {
            this.reflection.color = color;
        }
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getOutputFileHeader() {
        StringBuilder output = new StringBuilder(Feature2D.getDefaultOutputFileHeader());
        ArrayList<String> keys2 = new ArrayList<String>(this.attributes.keySet());
        Collections.sort(keys2);
        for (String key : keys2) {
            output.append("\t").append(key);
        }
        return output.toString();
    }

    public String simpleString() {
        return this.chr1 + "\t" + this.start1 + "\t" + this.end1 + "\t" + this.chr2 + "\t" + this.start2 + "\t" + this.end2;
    }

    public String justColorString() {
        return "\t" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue();
    }

    public String simpleStringWithColor() {
        return this.simpleString() + BEDPE_SPACER + this.justColorString();
    }

    public String toString() {
        StringBuilder output = new StringBuilder(this.simpleStringWithColor());
        ArrayList<String> keys2 = new ArrayList<String>(this.attributes.keySet());
        Collections.sort(keys2);
        for (String key : keys2) {
            output.append("\t").append(this.attributes.get(key));
        }
        return output.toString();
    }

    public ArrayList<String> getAttributeKeys() {
        ArrayList<String> keys2 = new ArrayList<String>(this.attributes.keySet());
        Collections.sort(keys2);
        return keys2;
    }

    public boolean hasAttributeKey(String key) {
        return this.attributes.containsKey(key);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String key, String newVal) {
        this.attributes.put(key, newVal);
        if (this.reflection != null) {
            this.reflection.attributes.put(key, newVal);
        }
    }

    public float getFloatAttribute(String key) {
        return Float.parseFloat(this.attributes.get(key));
    }

    public void addIntAttribute(String key, int value) {
        this.attributes.put(key, "" + value);
    }

    public void addFloatAttribute(String key, Float value) {
        this.attributes.put(key, "" + value);
    }

    public void addStringAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public boolean overlapsWith(Feature2D otherFeature) {
        float window1 = (otherFeature.getEnd1() - otherFeature.getStart1()) / 2L;
        float window2 = (otherFeature.getEnd2() - otherFeature.getStart2()) / 2L;
        long midOther1 = otherFeature.getMidPt1();
        long midOther2 = otherFeature.getMidPt2();
        return (float)midOther1 >= (float)this.start1 - window1 && (float)midOther1 <= (float)this.end1 + window1 && (float)midOther2 >= (float)this.start2 - window2 && (float)midOther2 <= (float)this.end2 + window2;
    }

    @Override
    public int compareTo(Feature2D o) {
        long[] comparisons;
        for (long i : comparisons = new long[]{this.chr1.compareTo(o.chr1), this.chr2.compareTo(o.chr2), this.start1 - o.start1, this.start2 - o.start2, this.end1 - o.end1, this.end2 - o.end2}) {
            if (i == 0L) continue;
            if (i > 0L) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public boolean isOnDiagonal() {
        return this.chr1.equals(this.chr2) && this.start1 == this.start2 && this.end1 == this.end2;
    }

    public Feature2D reflectionAcrossDiagonal() {
        if (this.reflection == null) {
            this.reflection = new Feature2D(this.featureType, this.chr2, this.start2, this.end2, this.chr1, this.start1, this.end1, this.color, this.attributes);
            this.reflection.reflection = this;
        }
        return this.reflection;
    }

    public boolean isInLowerLeft() {
        return this.chr1.equals(this.chr2) && this.start2 > this.start1;
    }

    public boolean isInUpperRight() {
        return this.chr1.equals(this.chr2) && this.start2 < this.start1;
    }

    public boolean doesNotContainAttributeKey(String attribute) {
        return !this.attributes.containsKey(attribute);
    }

    public boolean containsAttributeValue(String attribute) {
        return this.attributes.containsValue(attribute);
    }

    public String getLocationKey() {
        return this.start1 + "_" + this.start2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Feature2D other = (Feature2D)obj;
        if (this.chr1.equals(other.chr1) && this.chr2.equals(other.chr2) && Math.abs(this.start1 - other.start1) <= (long)tolerance && Math.abs(this.start2 - other.start2) <= (long)tolerance && Math.abs(this.end1 - other.end1) <= (long)tolerance) {
            return Math.abs(this.end2 - other.end2) <= (long)tolerance;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.chr1, this.end1, this.start1, this.chr2, this.end2, this.start2);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Feature2D deepCopy() {
        HashMap<String, String> attrClone = new HashMap<String, String>();
        for (String key : this.attributes.keySet()) {
            attrClone.put(key, this.attributes.get(key));
        }
        return new Feature2D(this.featureType, this.chr1, this.start1, this.end1, this.chr2, this.start2, this.end2, this.color, attrClone);
    }

    public boolean containsPoint(float x, float y) {
        return (float)this.start1 <= x && x <= (float)this.end1 && (float)this.start2 <= y && y <= (float)this.end2;
    }

    public static enum FeatureType {
        NONE,
        PEAK,
        DOMAIN,
        GENERIC,
        SCAFFOLD,
        SUPERSCAFFOLD,
        SELECTED_GROUP;

    }
}

