/*
 * Decompiled with CFR 0.152.
 */
package javastraw.feature1D;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javastraw.feature1D.Feature1D;
import javastraw.feature1D.Feature1DFilter;
import javastraw.feature1D.Feature1DFunction;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;

public class GenomeWide1DList<T extends Feature1D> {
    private final Map<String, List<T>> featureLists = new HashMap<String, List<T>>();

    public GenomeWide1DList() {
    }

    public GenomeWide1DList(ChromosomeHandler handler) {
        for (Chromosome c : handler.getChromosomeArray()) {
            this.featureLists.put("" + c.getIndex(), new ArrayList());
        }
    }

    public GenomeWide1DList(ChromosomeHandler handler, List<T> features) {
        this(handler);
        this.addAll(features);
    }

    public GenomeWide1DList(final GenomeWide1DList<T> gwList) {
        this.processLists(new Feature1DFunction<T>(){

            @Override
            public void process(String chr, List<T> featureList) {
                if (gwList.containsKey(chr)) {
                    GenomeWide1DList.this.addAll(gwList.getFeatures(chr));
                }
            }
        });
    }

    public boolean containsKey(String key) {
        return this.featureLists.containsKey(key);
    }

    public synchronized void setFeatures(String key, List<T> features) {
        this.featureLists.put(key, features);
    }

    public List<T> getFeatures(String key) {
        return this.featureLists.get(key);
    }

    public synchronized int size() {
        int val = 0;
        for (List<T> features : this.featureLists.values()) {
            val += features.size();
        }
        return val;
    }

    public synchronized void addAll(List<T> features) {
        for (Feature1D feature : features) {
            this.featureLists.get(feature.getKey()).add(feature.deepClone());
        }
    }

    public synchronized void filterLists(Feature1DFilter<T> filter) {
        for (String chr : this.featureLists.keySet()) {
            this.featureLists.put(chr, filter.filter(chr, this.featureLists.get(chr)));
        }
    }

    public synchronized void processLists(Feature1DFunction<T> function) {
        for (String key : this.featureLists.keySet()) {
            function.process(key, this.featureLists.get(key));
        }
    }

    public GenomeWide1DList<T> deepClone() {
        GenomeWide1DList<T> clone = new GenomeWide1DList<T>();
        for (String key : this.featureLists.keySet()) {
            clone.featureLists.put(key, this.cloneFeatureList(this.featureLists.get(key)));
        }
        return clone;
    }

    private List<T> cloneFeatureList(List<T> features) {
        ArrayList<Feature1D> clonedFeatures = new ArrayList<Feature1D>();
        for (Feature1D feature : features) {
            clonedFeatures.add(feature.deepClone());
        }
        return clonedFeatures;
    }

    public Set<String> keySet() {
        return this.featureLists.keySet();
    }

    public synchronized void addFeature(String key, T feature) {
        if (this.featureLists.containsKey(key)) {
            this.featureLists.get(key).add(feature);
        } else {
            ArrayList<T> features = new ArrayList<T>();
            features.add(feature);
            this.featureLists.put(key, features);
        }
    }

    public void simpleExport(File file) {
        try {
            final FileWriter fw = new FileWriter(file);
            this.processLists(new Feature1DFunction<T>(){

                @Override
                public void process(String chr, List<T> featureList) {
                    for (Feature1D t : featureList) {
                        try {
                            if (fw == null) continue;
                            fw.write(t.toString() + "\n");
                        }
                        catch (IOException e) {
                            System.err.println("Unable to write to file for exporting GWList");
                        }
                    }
                }
            });
            try {
                fw.close();
            }
            catch (IOException e) {
                System.err.println("Unable to close file for exporting GWList");
            }
        }
        catch (IOException e) {
            System.err.println("Unable to open file for exporting GWList");
        }
    }
}

