/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gelitext;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.gelitext.DiploidGenotype;
import htsjdk.tribble.gelitext.GeliTextFeature;
import htsjdk.tribble.readers.LineIterator;
import java.util.Arrays;

@Deprecated
public class GeliTextCodec
extends AsciiFeatureCodec<GeliTextFeature> {
    public GeliTextCodec() {
        super(GeliTextFeature.class);
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    @Override
    public GeliTextFeature decode(String line) {
        if (line.startsWith("#") || line.startsWith("@")) {
            return null;
        }
        String[] parts = line.trim().split("\\s+");
        return this.decode(parts);
    }

    @Override
    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".geli.calls") || path.toLowerCase().endsWith(".geli");
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    @Override
    public GeliTextFeature decode(String[] tokens2) {
        try {
            if (tokens2.length != 18) {
                throw new CodecLineParsingException("Invalid GeliTextFeature row found -- incorrect element count.  Expected 18, got " + tokens2.length + " line = " + CollectionUtil.join(Arrays.asList(tokens2), " "));
            }
            char[] x = tokens2[5].toUpperCase().toCharArray();
            Arrays.sort(x);
            String bestGenotype = new String(x);
            double[] genotypeLikelihoods = new double[10];
            int pieceIndex = 8;
            int offset = 0;
            while (pieceIndex < 18) {
                genotypeLikelihoods[offset] = Double.valueOf(tokens2[pieceIndex]);
                ++pieceIndex;
                ++offset;
            }
            return new GeliTextFeature(tokens2[0], Long.valueOf(tokens2[1]), Character.toUpperCase(tokens2[2].charAt(0)), Integer.valueOf(tokens2[3]), Integer.valueOf(tokens2[4]), DiploidGenotype.toDiploidGenotype(bestGenotype), Double.valueOf(tokens2[6]), Double.valueOf(tokens2[7]), genotypeLikelihoods);
        }
        catch (CodecLineParsingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse line " + CollectionUtil.join(Arrays.asList(tokens2), " "), e);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse line " + CollectionUtil.join(Arrays.asList(tokens2), " "), e);
        }
    }
}

