/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.zip.DeflaterFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class BlockCompressedOutputStream
extends OutputStream
implements LocationAware {
    private static final Log log = Log.getInstance(BlockCompressedOutputStream.class);
    private static int defaultCompressionLevel = BlockCompressedStreamConstants.DEFAULT_COMPRESSION_LEVEL;
    private static DeflaterFactory defaultDeflaterFactory = new DeflaterFactory();
    private final BinaryCodec codec;
    private final byte[] uncompressedBuffer = new byte[65498];
    private int numUncompressedBytes = 0;
    private final byte[] compressedBuffer = new byte[65518];
    private final Deflater deflater;
    private final Deflater noCompressionDeflater = new Deflater(0, true);
    private final CRC32 crc32 = new CRC32();
    private Path file = null;
    private long mBlockAddress = 0L;
    private final byte[] singleByteArray = new byte[1];

    public static void setDefaultCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + compressionLevel);
        }
        defaultCompressionLevel = compressionLevel;
    }

    public static int getDefaultCompressionLevel() {
        return defaultCompressionLevel;
    }

    public static void setDefaultDeflaterFactory(DeflaterFactory deflaterFactory) {
        if (deflaterFactory == null) {
            throw new IllegalArgumentException("null deflaterFactory");
        }
        defaultDeflaterFactory = deflaterFactory;
    }

    public static DeflaterFactory getDefaultDeflaterFactory() {
        return defaultDeflaterFactory;
    }

    public BlockCompressedOutputStream(String filename) {
        this(filename, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(File file) {
        this(file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(String filename, int compressionLevel) {
        this(new File(filename), compressionLevel);
    }

    public BlockCompressedOutputStream(File file, int compressionLevel) {
        this(file, compressionLevel, defaultDeflaterFactory);
    }

    public BlockCompressedOutputStream(File file, int compressionLevel, DeflaterFactory deflaterFactory) {
        this(IOUtil.toPath(file), compressionLevel, deflaterFactory);
    }

    public BlockCompressedOutputStream(Path path, int compressionLevel, DeflaterFactory deflaterFactory) {
        this.file = path;
        this.codec = new BinaryCodec(path, true);
        this.deflater = deflaterFactory.makeDeflater(compressionLevel, true);
        log.debug("Using deflater: " + this.deflater.getClass().getSimpleName());
    }

    public BlockCompressedOutputStream(OutputStream os, File file) {
        this(os, file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(OutputStream os, Path file) {
        this(os, file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(OutputStream os, File file, int compressionLevel) {
        this(os, file, compressionLevel, defaultDeflaterFactory);
    }

    public BlockCompressedOutputStream(OutputStream os, Path file, int compressionLevel) {
        this(os, file, compressionLevel, defaultDeflaterFactory);
    }

    public BlockCompressedOutputStream(OutputStream os, File file, int compressionLevel, DeflaterFactory deflaterFactory) {
        this(os, IOUtil.toPath(file), compressionLevel, deflaterFactory);
    }

    public BlockCompressedOutputStream(OutputStream os, Path file, int compressionLevel, DeflaterFactory deflaterFactory) {
        this.file = file;
        this.codec = new BinaryCodec(os);
        if (file != null) {
            this.codec.setOutputFileName(file.toAbsolutePath().toUri().toString());
        }
        this.deflater = deflaterFactory.makeDeflater(compressionLevel, true);
        log.debug("Using deflater: " + this.deflater.getClass().getSimpleName());
    }

    public static BlockCompressedOutputStream maybeBgzfWrapOutputStream(File location, OutputStream output) {
        if (!(output instanceof BlockCompressedOutputStream)) {
            return new BlockCompressedOutputStream(output, location);
        }
        return (BlockCompressedOutputStream)output;
    }

    @Override
    public void write(byte[] bytes2) throws IOException {
        this.write(bytes2, 0, bytes2.length);
    }

    @Override
    public void write(byte[] bytes2, int startIndex, int numBytes) throws IOException {
        assert (this.numUncompressedBytes < this.uncompressedBuffer.length);
        while (numBytes > 0) {
            int bytesToWrite = Math.min(this.uncompressedBuffer.length - this.numUncompressedBytes, numBytes);
            System.arraycopy(bytes2, startIndex, this.uncompressedBuffer, this.numUncompressedBytes, bytesToWrite);
            this.numUncompressedBytes += bytesToWrite;
            startIndex += bytesToWrite;
            assert ((numBytes -= bytesToWrite) >= 0);
            if (this.numUncompressedBytes != this.uncompressedBuffer.length) continue;
            this.deflateBlock();
        }
    }

    @Override
    public void flush() throws IOException {
        while (this.numUncompressedBytes > 0) {
            this.deflateBlock();
        }
        this.codec.getOutputStream().flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.codec.writeBytes(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        this.codec.close();
        if (this.file == null || !Files.isRegularFile(this.file, new LinkOption[0])) {
            return;
        }
        if (BlockCompressedInputStream.checkTermination(this.file) != BlockCompressedInputStream.FileTermination.HAS_TERMINATOR_BLOCK) {
            throw new IOException("Terminator block not found after closing BGZF file " + this.file);
        }
    }

    @Override
    public void write(int bite) throws IOException {
        this.singleByteArray[0] = (byte)bite;
        this.write(this.singleByteArray);
    }

    public long getFilePointer() {
        return BlockCompressedFilePointerUtil.makeFilePointer(this.mBlockAddress, this.numUncompressedBytes);
    }

    @Override
    public long getPosition() {
        return this.getFilePointer();
    }

    private int deflateBlock() {
        if (this.numUncompressedBytes == 0) {
            return 0;
        }
        int bytesToCompress = this.numUncompressedBytes;
        this.deflater.reset();
        this.deflater.setInput(this.uncompressedBuffer, 0, bytesToCompress);
        this.deflater.finish();
        int compressedSize = this.deflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
        if (!this.deflater.finished()) {
            this.noCompressionDeflater.reset();
            this.noCompressionDeflater.setInput(this.uncompressedBuffer, 0, bytesToCompress);
            this.noCompressionDeflater.finish();
            compressedSize = this.noCompressionDeflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
            if (!this.noCompressionDeflater.finished()) {
                throw new IllegalStateException("unpossible");
            }
        }
        this.crc32.reset();
        this.crc32.update(this.uncompressedBuffer, 0, bytesToCompress);
        int totalBlockSize = this.writeGzipBlock(compressedSize, bytesToCompress, this.crc32.getValue());
        assert (bytesToCompress <= this.numUncompressedBytes);
        if (bytesToCompress == this.numUncompressedBytes) {
            this.numUncompressedBytes = 0;
        } else {
            System.arraycopy(this.uncompressedBuffer, bytesToCompress, this.uncompressedBuffer, 0, this.numUncompressedBytes - bytesToCompress);
            this.numUncompressedBytes -= bytesToCompress;
        }
        this.mBlockAddress += (long)totalBlockSize;
        return totalBlockSize;
    }

    private int writeGzipBlock(int compressedSize, int uncompressedSize, long crc) {
        this.codec.writeByte((byte)31);
        this.codec.writeByte(139);
        this.codec.writeByte((byte)8);
        this.codec.writeByte(4);
        this.codec.writeInt(0);
        this.codec.writeByte(0);
        this.codec.writeByte(255);
        this.codec.writeShort((short)6);
        this.codec.writeByte((byte)66);
        this.codec.writeByte((byte)67);
        this.codec.writeShort((short)2);
        int totalBlockSize = compressedSize + 18 + 8;
        this.codec.writeShort((short)(totalBlockSize - 1));
        this.codec.writeBytes(this.compressedBuffer, 0, compressedSize);
        this.codec.writeInt((int)crc);
        this.codec.writeInt(uncompressedSize);
        return totalBlockSize;
    }
}

