/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.metrics;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MetricsFile<BEAN extends MetricBase, HKEY extends Comparable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MAJOR_HEADER_PREFIX = "## ";
    public static final String MINOR_HEADER_PREFIX = "# ";
    public static final String SEPARATOR = "\t";
    public static final String HISTO_HEADER = "## HISTOGRAM\t";
    public static final String METRIC_HEADER = "## METRICS CLASS\t";
    private final Set<String> columnLabels = new HashSet<String>();
    private final List<Header> headers = new ArrayList<Header>();
    private final List<BEAN> metrics = new ArrayList<BEAN>();
    private final List<Histogram<HKEY>> histograms = new ArrayList<Histogram<HKEY>>();

    public void addHeader(Header h) {
        this.headers.add(h);
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addMetric(BEAN bean) {
        this.metrics.add(bean);
    }

    public void addAllMetrics(Iterable<BEAN> beanz) {
        for (MetricBase bean : beanz) {
            this.addMetric(bean);
        }
    }

    public List<BEAN> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public Set<String> getMetricsColumnLabels() {
        return Collections.unmodifiableSet(this.columnLabels);
    }

    public Histogram<HKEY> getHistogram() {
        if (!this.histograms.isEmpty()) {
            return this.histograms.get(0);
        }
        return null;
    }

    public void setHistogram(Histogram<HKEY> histogram) {
        if (this.histograms.isEmpty()) {
            if (histogram != null) {
                this.histograms.add(histogram);
            }
        } else {
            this.histograms.set(0, histogram);
        }
    }

    public void addHistogram(Histogram<HKEY> histogram) {
        this.histograms.add(histogram);
    }

    public List<Histogram<HKEY>> getAllHistograms() {
        return Collections.unmodifiableList(this.histograms);
    }

    public int getNumHistograms() {
        return this.histograms.size();
    }

    public List<Header> getHeaders(Class<? extends Header> type) {
        ArrayList<Header> tmp = new ArrayList<Header>();
        for (Header h : this.headers) {
            if (!h.getClass().equals(type)) continue;
            tmp.add(h);
        }
        return tmp;
    }

    public void write(File f) {
        FileWriter w = null;
        try {
            w = new FileWriter(f);
            this.write(w);
        }
        catch (IOException ioe) {
            throw new SAMException("Could not write metrics to file: " + f.getAbsolutePath(), ioe);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void write(Writer w) {
        try {
            FormatUtil formatter = new FormatUtil();
            BufferedWriter out = new BufferedWriter(w);
            this.printHeaders(out);
            out.newLine();
            this.printBeanMetrics(out, formatter);
            out.newLine();
            this.printHistogram(out, formatter);
            out.newLine();
            out.flush();
        }
        catch (IOException ioe) {
            throw new SAMException("Could not write metrics file.", ioe);
        }
    }

    private void printHeaders(BufferedWriter out) throws IOException {
        for (Header h : this.headers) {
            out.append(MAJOR_HEADER_PREFIX);
            out.append(h.getClass().getName());
            out.newLine();
            out.append(MINOR_HEADER_PREFIX);
            out.append(h.toString());
            out.newLine();
        }
    }

    private void printBeanMetrics(BufferedWriter out, FormatUtil formatter) throws IOException {
        if (this.metrics.isEmpty()) {
            return;
        }
        out.append(METRIC_HEADER + this.getBeanType().getName());
        out.newLine();
        Field[] fields = this.getBeanType().getFields();
        int fieldCount = fields.length;
        for (int i = 0; i < fieldCount; ++i) {
            out.append(fields[i].getName());
            if (i < fieldCount - 1) {
                out.append(SEPARATOR);
                continue;
            }
            out.newLine();
        }
        for (MetricBase bean : this.metrics) {
            for (int i = 0; i < fieldCount; ++i) {
                try {
                    Object value = fields[i].get(bean);
                    out.append(StringUtil.assertCharactersNotInString(formatter.format(value), '\t', '\n'));
                    if (i < fieldCount - 1) {
                        out.append(SEPARATOR);
                        continue;
                    }
                    out.newLine();
                    continue;
                }
                catch (IllegalAccessException iae) {
                    throw new SAMException("Could not read property " + fields[i].getName() + " from class of type " + bean.getClass());
                }
            }
        }
        out.flush();
    }

    private void printHistogram(BufferedWriter out, FormatUtil formatter) throws IOException {
        ArrayList<Histogram<HKEY>> nonEmptyHistograms = new ArrayList<Histogram<HKEY>>();
        for (Histogram<HKEY> histo : this.histograms) {
            if (histo.isEmpty()) continue;
            nonEmptyHistograms.add(histo);
        }
        if (nonEmptyHistograms.isEmpty()) {
            return;
        }
        TreeSet keys2 = new TreeSet(((Histogram)nonEmptyHistograms.get(0)).comparator());
        for (Histogram histogram : nonEmptyHistograms) {
            if (histogram == null) continue;
            keys2.addAll(histogram.keySet());
        }
        out.append(HISTO_HEADER + ((Comparable)((Histogram)nonEmptyHistograms.get(0)).keySet().iterator().next()).getClass().getName());
        out.newLine();
        out.append(StringUtil.assertCharactersNotInString(((Histogram)nonEmptyHistograms.get(0)).getBinLabel(), '\t', '\n'));
        for (Histogram histogram : nonEmptyHistograms) {
            out.append(SEPARATOR);
            out.append(StringUtil.assertCharactersNotInString(histogram.getValueLabel(), '\t', '\n'));
        }
        out.newLine();
        for (Comparable comparable : keys2) {
            out.append(comparable.toString());
            for (Histogram histogram : nonEmptyHistograms) {
                Histogram.Bin<Comparable> bin = histogram.get(comparable);
                double value = bin == null ? 0.0 : bin.getValue();
                out.append(SEPARATOR);
                out.append(formatter.format(value));
            }
            out.newLine();
        }
    }

    private Class<?> getBeanType() {
        if (this.metrics.isEmpty()) {
            return null;
        }
        return ((MetricBase)this.metrics.get(0)).getClass();
    }

    public void read(Reader r) {
        block32: {
            BufferedReader in = new BufferedReader(r);
            FormatUtil formatter = new FormatUtil();
            String line = null;
            try {
                String className;
                Header header = null;
                while ((line = in.readLine()) != null) {
                    if ("".equals(line = line.trim())) continue;
                    if (line.startsWith(METRIC_HEADER) || line.startsWith(HISTO_HEADER)) break;
                    if (line.startsWith(MAJOR_HEADER_PREFIX)) {
                        if (header != null) {
                            throw new IllegalStateException("Consecutive header class lines encountered.");
                        }
                        className = line.substring(MAJOR_HEADER_PREFIX.length()).trim();
                        try {
                            header = (Header)this.loadClass(className, true).newInstance();
                            continue;
                        }
                        catch (Exception e) {
                            throw new SAMException("Error load and/or instantiating an instance of " + className, e);
                        }
                    }
                    if (line.startsWith(MINOR_HEADER_PREFIX)) {
                        if (header == null) {
                            throw new IllegalStateException("Header class must precede header value:" + line);
                        }
                        header.parse(line.substring(MINOR_HEADER_PREFIX.length()));
                        this.headers.add(header);
                        header = null;
                        continue;
                    }
                    throw new SAMException("Illegal state. Found following string in metrics file header: " + line);
                }
                while (line != null && !line.trim().startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine();
                }
                if (line != null && (line = line.trim()).startsWith(METRIC_HEADER)) {
                    className = line.split(SEPARATOR)[1];
                    Class<?> type = null;
                    try {
                        type = this.loadClass(className, true);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new SAMException("Could not locate class with name " + className, cnfe);
                    }
                    String[] fieldNames = in.readLine().split(SEPARATOR);
                    Collections.addAll(this.columnLabels, fieldNames);
                    Field[] fields = new Field[fieldNames.length];
                    for (int i = 0; i < fieldNames.length; ++i) {
                        try {
                            fields[i] = type.getField(fieldNames[i]);
                            continue;
                        }
                        catch (Exception e) {
                            throw new SAMException("Could not get field with name " + fieldNames[i] + " from class " + type.getName());
                        }
                    }
                    while ((line = in.readLine()) != null && !"".equals(line.trim())) {
                        String[] values2 = line.split(SEPARATOR, -1);
                        MetricBase bean = null;
                        try {
                            bean = (MetricBase)type.newInstance();
                        }
                        catch (Exception e) {
                            throw new SAMException("Error instantiating a " + type.getName(), e);
                        }
                        for (int i = 0; i < fields.length; ++i) {
                            Object value = null;
                            if (values2[i] != null && !values2[i].isEmpty()) {
                                value = formatter.parseObject(values2[i], fields[i].getType());
                            }
                            try {
                                fields[i].set(bean, value);
                                continue;
                            }
                            catch (Exception e) {
                                throw new SAMException("Error setting field " + fields[i].getName() + " on class of type " + type.getName(), e);
                            }
                        }
                        this.metrics.add(bean);
                    }
                }
                while (line != null && !line.trim().startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine();
                }
                if (line == null || !(line = line.trim()).startsWith(HISTO_HEADER)) break block32;
                String keyClassName = line.split(SEPARATOR)[1].trim();
                Class<?> keyClass = null;
                try {
                    keyClass = this.loadClass(keyClassName, true);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new SAMException("Could not load class with name " + keyClassName);
                }
                String[] labels = in.readLine().split(SEPARATOR);
                for (int i = 1; i < labels.length; ++i) {
                    this.histograms.add(new Histogram(labels[0], labels[i]));
                }
                while ((line = in.readLine()) != null && !"".equals(line)) {
                    String[] fields = line.trim().split(SEPARATOR);
                    Comparable key = (Comparable)formatter.parseObject(fields[0], keyClass);
                    for (int i = 1; i < fields.length; ++i) {
                        double value = formatter.parseDouble(fields[i]);
                        this.histograms.get(i - 1).increment(key, value);
                    }
                }
            }
            catch (IOException ioe) {
                throw new SAMException("Could not read metrics from reader.", ioe);
            }
            finally {
                CloserUtil.close(in);
            }
        }
    }

    private Class<?> loadClass(String className, boolean tryOtherPackages) throws ClassNotFoundException {
        String[] packages = new String[]{"edu.mit.broad.picard.genotype.concordance", "edu.mit.broad.picard.genotype.fingerprint", "edu.mit.broad.picard.ic", "edu.mit.broad.picard.illumina", "edu.mit.broad.picard.jumping", "edu.mit.broad.picard.quality", "edu.mit.broad.picard.samplevalidation", "htsjdk.samtools.analysis", "htsjdk.samtools.analysis.directed", "htsjdk.samtools.sam", "htsjdk.samtools.metrics", "picard.sam", "picard.metrics", "picard.illumina", "picard.analysis", "picard.analysis.directed", "picard.vcf"};
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (tryOtherPackages) {
                for (String p : packages) {
                    try {
                        return this.loadClass(p + className.substring(className.lastIndexOf(46)), false);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (className.indexOf(36) <= -1) continue;
                        try {
                            return this.loadClass(p + "." + className.substring(className.lastIndexOf(36) + 1), false);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            // empty catch block
                        }
                    }
                }
            }
            throw cnfe;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MetricsFile that = (MetricsFile)o;
        if (!this.areHeadersEqual(that)) {
            return false;
        }
        if (!this.areMetricsEqual(that)) {
            return false;
        }
        return this.areHistogramsEqual(that);
    }

    public boolean areHeadersEqual(MetricsFile that) {
        return this.headers.equals(that.headers);
    }

    public boolean areMetricsEqual(MetricsFile that) {
        return this.metrics.equals(that.metrics);
    }

    public boolean areHistogramsEqual(MetricsFile that) {
        return this.histograms.equals(that.histograms);
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = 31 * result + this.metrics.hashCode();
        return result;
    }

    public static <T extends MetricBase> List<T> readBeans(File file) {
        MetricsFile metricsFile = new MetricsFile();
        BufferedReader in = IOUtil.openFileForBufferedReading(file);
        metricsFile.read(in);
        CloserUtil.close(in);
        return metricsFile.getMetrics();
    }

    public static List<Header> readHeaders(File file) {
        try {
            MetricsFile metricsFile = new MetricsFile();
            metricsFile.read(new FileReader(file));
            return metricsFile.getHeaders();
        }
        catch (FileNotFoundException e) {
            throw new SAMException(e.getMessage(), e);
        }
    }

    public static boolean areMetricsEqual(File file1, File file2) {
        try {
            MetricsFile mf1 = new MetricsFile();
            MetricsFile mf2 = new MetricsFile();
            mf1.read(new FileReader(file1));
            mf2.read(new FileReader(file2));
            return mf1.areMetricsEqual(mf2);
        }
        catch (FileNotFoundException e) {
            throw new SAMException(e.getMessage(), e);
        }
    }

    public static boolean areMetricsAndHistogramsEqual(File file1, File file2) {
        try {
            MetricsFile mf1 = new MetricsFile();
            MetricsFile mf2 = new MetricsFile();
            mf1.read(new FileReader(file1));
            mf2.read(new FileReader(file2));
            return mf1.areMetricsEqual(mf2) && mf1.areHistogramsEqual(mf2);
        }
        catch (FileNotFoundException e) {
            throw new SAMException(e.getMessage(), e);
        }
    }
}

