/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GolombIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GolombIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.GOLOMB;
    private int m;
    private int offset;

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int m) {
        GolombIntegerEncoding golombIntegerEncoding = new GolombIntegerEncoding();
        golombIntegerEncoding.m = m;
        golombIntegerEncoding.offset = 0;
        return new EncodingParams(ENCODING_ID, golombIntegerEncoding.toByteArray());
    }

    public static EncodingParams toParam(int m, int offset) {
        GolombIntegerEncoding e = new GolombIntegerEncoding();
        e.m = m;
        e.offset = offset;
        return new EncodingParams(ENCODING_ID, e.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8((int)this.offset, (ByteBuffer)buffer);
        ITF8.writeUnsignedITF8((int)this.m, (ByteBuffer)buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.offset = ITF8.readUnsignedITF8(buffer);
        this.m = ITF8.readUnsignedITF8(buffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new GolombIntegerCodec(this.m, this.offset);
    }
}

