/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class IndexStreamBuffer
implements IndexFileBuffer {
    private final SeekableStream in;
    private final ByteBuffer tmpBuf;

    private static void readFully(SeekableStream in, byte[] buffer, int length) {
        int read;
        int readThisLoop;
        for (read = 0; read < length; read += readThisLoop) {
            try {
                readThisLoop = in.read(buffer, read, length - read);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            if (readThisLoop == -1) break;
        }
        if (read != length) {
            throw new RuntimeIOException("Expected to read " + length + " bytes, but expired stream after " + read + ".");
        }
    }

    public IndexStreamBuffer(SeekableStream s) {
        this.in = s;
        this.tmpBuf = ByteBuffer.allocate(8);
        this.tmpBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void readBytes(byte[] bytes2) {
        IndexStreamBuffer.readFully(this.in, bytes2, bytes2.length);
    }

    @Override
    public void seek(long position) {
        try {
            this.in.seek(position);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int readInteger() {
        IndexStreamBuffer.readFully(this.in, this.tmpBuf.array(), 4);
        return this.tmpBuf.getInt(0);
    }

    @Override
    public long readLong() {
        IndexStreamBuffer.readFully(this.in, this.tmpBuf.array(), 8);
        return this.tmpBuf.getLong(0);
    }

    @Override
    public void skipBytes(int count) {
        try {
            int skipped;
            for (int s = count; s > 0; s -= skipped) {
                skipped = (int)this.in.skip(s);
                if (skipped > 0) continue;
                throw new RuntimeIOException("Failed to skip " + s);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public long position() {
        try {
            return (int)this.in.position();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

