/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.build.ContainerParser;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramContainerIterator;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.build.CramSpanContainerIterator;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CRAMIterator
implements SAMRecordIterator {
    private final CountingInputStream countingInputStream;
    private final CramHeader cramHeader;
    private final ArrayList<SAMRecord> records;
    private SAMRecord nextRecord = null;
    private final CramNormalizer normalizer;
    private byte[] refs;
    private int prevSeqId = -1;
    public Container container;
    private SamReader mReader;
    long firstContainerOffset = 0L;
    private final Iterator<Container> containerIterator;
    private final ContainerParser parser;
    private final CRAMReferenceSource referenceSource;
    private Iterator<SAMRecord> iterator = Collections.emptyList().iterator();
    private ValidationStringency validationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private long samRecordIndex;
    private ArrayList<CramCompressionRecord> cramRecords;

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public CRAMIterator(InputStream inputStream, CRAMReferenceSource referenceSource, ValidationStringency validationStringency) {
        if (null == referenceSource) {
            throw new CRAMException("A reference source is required for CRAM files");
        }
        this.countingInputStream = new CountingInputStream(inputStream);
        this.referenceSource = referenceSource;
        this.validationStringency = validationStringency;
        CramContainerIterator containerIterator = new CramContainerIterator(this.countingInputStream);
        this.cramHeader = containerIterator.getCramHeader();
        this.containerIterator = containerIterator;
        this.firstContainerOffset = this.countingInputStream.getCount();
        this.records = new ArrayList(CRAMContainerStreamWriter.DEFAULT_RECORDS_PER_SLICE);
        this.normalizer = new CramNormalizer(this.cramHeader.getSamFileHeader(), referenceSource);
        this.parser = new ContainerParser(this.cramHeader.getSamFileHeader());
    }

    public CRAMIterator(SeekableStream seekableStream, CRAMReferenceSource referenceSource, long[] coordinates, ValidationStringency validationStringency) {
        if (null == referenceSource) {
            throw new CRAMException("A reference source is required for CRAM files");
        }
        this.countingInputStream = new CountingInputStream(seekableStream);
        this.referenceSource = referenceSource;
        this.validationStringency = validationStringency;
        CramSpanContainerIterator containerIterator = CramSpanContainerIterator.fromFileSpan(seekableStream, coordinates);
        this.cramHeader = containerIterator.getCramHeader();
        this.containerIterator = containerIterator;
        this.firstContainerOffset = containerIterator.getFirstContainerOffset();
        this.records = new ArrayList(CRAMContainerStreamWriter.DEFAULT_RECORDS_PER_SLICE);
        this.normalizer = new CramNormalizer(this.cramHeader.getSamFileHeader(), referenceSource);
        this.parser = new ContainerParser(this.cramHeader.getSamFileHeader());
    }

    @Deprecated
    public CRAMIterator(SeekableStream seekableStream, CRAMReferenceSource referenceSource, long[] coordinates) {
        this(seekableStream, referenceSource, coordinates, ValidationStringency.DEFAULT_STRINGENCY);
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    void nextContainer() throws IllegalArgumentException, CRAMException {
        if (this.containerIterator != null) {
            if (!this.containerIterator.hasNext()) {
                this.records.clear();
                this.nextRecord = null;
                return;
            }
            this.container = this.containerIterator.next();
            if (this.container.isEOF()) {
                this.records.clear();
                this.nextRecord = null;
                return;
            }
        } else {
            this.container = ContainerIO.readContainer(this.cramHeader.getVersion(), (InputStream)this.countingInputStream);
            if (this.container.isEOF()) {
                this.records.clear();
                this.nextRecord = null;
                return;
            }
        }
        this.records.clear();
        if (this.cramRecords == null) {
            this.cramRecords = new ArrayList(this.container.nofRecords);
        } else {
            this.cramRecords.clear();
        }
        this.parser.getRecords(this.container, this.cramRecords, this.validationStringency);
        if (this.container.sequenceId == -1) {
            this.refs = new byte[0];
            this.prevSeqId = -1;
        } else if (this.container.sequenceId == -2) {
            this.refs = null;
            this.prevSeqId = -2;
        } else if (this.prevSeqId < 0 || this.prevSeqId != this.container.sequenceId) {
            SAMSequenceRecord sequence = this.cramHeader.getSamFileHeader().getSequence(this.container.sequenceId);
            this.refs = this.referenceSource.getReferenceBases(sequence, true);
            if (this.refs == null) {
                throw new CRAMException(String.format("Contig %s not found in the reference file.", sequence.getSequenceName()));
            }
            this.prevSeqId = this.container.sequenceId;
        }
        for (int i = 0; i < this.container.slices.length; ++i) {
            Slice slice = this.container.slices[i];
            if (slice.sequenceId < 0 || slice.validateRefMD5(this.refs)) continue;
            String msg = String.format("Reference sequence MD5 mismatch for slice: sequence id %d, start %d, span %d, expected MD5 %s", slice.sequenceId, slice.alignmentStart, slice.alignmentSpan, String.format("%032x", new BigInteger(1, slice.refMD5)));
            throw new CRAMException(msg);
        }
        this.normalizer.normalize(this.cramRecords, this.refs, 0, this.container.header.substitutionMatrix);
        Cram2SamRecordFactory cramToSamRecordFactory = new Cram2SamRecordFactory(this.cramHeader.getSamFileHeader());
        for (CramCompressionRecord cramRecord : this.cramRecords) {
            SAMRecord samRecord = cramToSamRecordFactory.create(cramRecord);
            if (!cramRecord.isSegmentUnmapped()) {
                SAMSequenceRecord sequence = this.cramHeader.getSamFileHeader().getSequence(cramRecord.sequenceId);
                this.refs = this.referenceSource.getReferenceBases(sequence, true);
            }
            samRecord.setValidationStringency(this.validationStringency);
            if (this.mReader != null) {
                long chunkStart = this.container.offset << 16 | (long)cramRecord.sliceIndex;
                long chunkEnd = (this.container.offset << 16 | (long)cramRecord.sliceIndex) + 1L;
                this.nextRecord.setFileSource(new SAMFileSource(this.mReader, new BAMFileSpan(new Chunk(chunkStart, chunkEnd))));
            }
            this.records.add(samRecord);
        }
        this.cramRecords.clear();
        this.iterator = this.records.iterator();
    }

    public boolean advanceToAlignmentInContainer(int refIndex, int pos) {
        if (!this.hasNext()) {
            return false;
        }
        int i = 0;
        for (SAMRecord record : this.records) {
            if (refIndex != -1 && record.getReferenceIndex() != refIndex) continue;
            if (pos <= 0) {
                if (record.getAlignmentStart() == 0) {
                    this.iterator = this.records.listIterator(i);
                    return true;
                }
            } else if (record.getAlignmentStart() >= pos) {
                this.iterator = this.records.listIterator(i);
                return true;
            }
            ++i;
        }
        this.iterator = Collections.emptyList().iterator();
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.container != null && this.container.isEOF()) {
            return false;
        }
        if (!this.iterator.hasNext()) {
            this.nextContainer();
        }
        return !this.records.isEmpty();
    }

    @Override
    public SAMRecord next() {
        if (this.hasNext()) {
            SAMRecord samRecord = this.iterator.next();
            if (this.validationStringency != ValidationStringency.SILENT) {
                SAMUtils.processValidationErrors(samRecord.isValid(), this.samRecordIndex++, this.validationStringency);
            }
            return samRecord;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Removal of records not implemented.");
    }

    @Override
    public void close() {
        this.records.clear();
        try {
            if (this.countingInputStream != null) {
                this.countingInputStream.close();
            }
        }
        catch (RuntimeIOException runtimeIOException) {
            // empty catch block
        }
    }

    @Override
    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        return SamReader.AssertingIterator.of(this).assertSorted(sortOrder);
    }

    public SamReader getFileSource() {
        return this.mReader;
    }

    public void setFileSource(SamReader mReader) {
        this.mReader = mReader;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.cramHeader.getSamFileHeader();
    }
}

