/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;

public class QuarterNameConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT = new ConverterContext("QuarterName");
    private static String _quarterNamePattern;

    @Override
    public String toString(Object object, ConverterContext context) {
        if (object == null || !(object instanceof Number)) {
            return "";
        }
        int qty = ((Number)object).intValue();
        if (qty >= 0 && qty < 4) {
            return MessageFormat.format(this.getQuarterNamePattern(), qty + 1);
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext context) {
        String quarterNamePattern = this.getQuarterNamePattern();
        try {
            Object[] values2 = new MessageFormat(quarterNamePattern).parse(string);
            if (values2.length > 0) {
                return Integer.parseInt("" + values2[0]) - 1;
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public String getQuarterNamePattern() {
        if (_quarterNamePattern == null) {
            return this.getResourceString("Quarter.quarter");
        }
        return _quarterNamePattern;
    }

    public void setQuarterNamePattern(String quarterName) {
        _quarterNamePattern = quarterName;
    }

    protected String getResourceString(String key) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        return resourceBundle.getString(key);
    }
}

