#### super enhancer data analysis pipeline

# requirements: bowtie2 (v2.3.5.1), samtools (1.12), bedtools (2.29.2), sicer, macs2 (v2.1.2), uscstools (v4)
# hg38.chrom.sizes can be downloaded from UCSC table browser
# hg38_bowtie2_index can be generated by bowtie2 build function
 
# H3K27ac data pre-process
bowtie2 -p 8 -X 2000 -x hg38_bowtie2_index -1 H3K27ac_p1.fastq -2 H3K27ac_p2.fastq -S H3K27ac.sam 2>&1 >>/dev/null | tee H3K27ac_bowtie2PE.out
samtools view -bS H3K27ac.sam > H3K27ac_raw.bam
samtools view -H H3K27ac_raw.bam > H3K27ac_filtered.sam
samtools view -f 0x2 H3K27ac_raw.bam | awk 'NR % 2 == 1{mapq=$5;forward=$0} NR % 2 == 0{if($5>=30 && mapq>=30 && substr($3,1,3)=="chr" && $7=="=" ) print forward"\n"$0}' >> H3K27ac_filtered.sam
samtools view -bS H3K27ac_filtered.sam > H3K27ac.bam
bamToBed -i H3K27ac.bam -bedpe | awk '{OFS="\t"; print $1,$2,$6,$7,$8,"."}' | sort -k 1,1 -k 2,2g -k 3,3g|cut -f 1-3 |uniq > H3K27ac_PEuniq.bed

# super enhancer detection
sicer -t H3K27ac.bam -c HCASMC_IgG.bam -s hg38 -w 200 -rt 1 -f 150 -egf 0.74 -fdr 0.01 -g 600 -e 1000
mv H3K27ac-W200-G600-FDR0.01-island.bed H3K27ac_sicerPeak.bed
awk '{OFS="\t";if($3-$2>=10000) print $0}' H3K27ac_sicerPeak.bed > H3K27ac_sicer10kb.bed

# fetch reads on super enhancer region
intersectBed -a H3K27ac_PEuniq.bed  -b ../../H3K27ac_nonPromoter.bed -u > H3K27ac_readsOnLongNPpeaks.bed
macs2 pileup -i H3K27ac_readsOnLongNPpeaks.bed --extsize 1 -f BEDPE -o H3K27ac_readsOnLongNPpeaks_cuts.bdg
bedClip H3K27ac_readsOnLongNPpeaks_cuts.bdg hg38.chrom.sizes H3K27ac_readsOnLongNPpeaks_cuts.bdg.clip
sort -k1,1 -k2,2n H3K27ac_readsOnLongNPpeaks_cuts.bdg.clip > H3K27ac_readsOnLongNPpeaks_cuts.bdg.clip.sort
bedGraphToBigWig H3K27ac_readsOnLongNPpeaks_cuts.bdg.clip.sort hg38.chrom.sizes H3K27ac_readsOnLongNPpeaks_cuts.bw

bdg2bw H3K27ac_readsOnLongNPpeaks_cuts.bdg /nv/vol190/zanglab/sh8tv/Data/Genome/hg38/hg38_clean.len

# calculate regulatory potential of each gene from reads on super enhancer region
python RPCalc.py -n H3K27ac_readsOnLongNPpeaks_RP.bed -b H3K27ac_readsOnLongNPpeaks_cuts.bw


#### bulk ATAC-seq data analysis pipeline (PEPATAC)
# requirements: pepatac (v0.10.3), singularity (v3.1.1)
# pepatac.py, hg38_TSS.tsv, rCRSd, human_repeats, and hg38.blacklist.bed can all be downloaded from PEPATAC website (https://github.com/databio/pepatac)

# bulk ATAC-seq data process
singularity exec --bind hg38 pepatac pepatac.py -O PEPATAC_output -Q paired -C pepatac.yaml -gs hs -S bulkATAC -I bulkATAC_p1.fq.gz -I2 bulkATAC_p2.fq.gz -G hg38 --TSS-name hg38_TSS.tsv --prealignments rCRSd human_repeats --blacklist hg38.blacklist.bed 


