import pickle
import cv2
import matplotlib.pyplot as plt

import numpy as np


def pkl_dump(filename, obj):
    with open(filename, 'wb') as f:
        pickle.dump(obj, f)


def pkl_load(filename):
    with open(filename, 'rb') as f:
        data = pickle.load(f)
    return data


def load_data():
    with open('2022-06-27-02_06_52.pkl', 'rb') as f:
        data = pickle.load(f)

    x = np.asarray(data['x'])
    y = np.asarray(data['y'])
    tx = np.asarray(x[550:600])
    ty = np.asarray(y[550:600])
    return x, y, tx, ty


if __name__ == '__main__':
    x, y, tx, ty = load_data()
    print(x.shape)  # (60000, 28, 28)
    print(y.shape)  # (60000,)
    print(y[:3])  # array([7, 2, 1], dtype=uint8)
    print(ty)
    cv2.imshow('img', x[700])
    cv2.waitKey()


