import autokeras as ak

import utils

x_train, y_train, x_test, y_test = utils.load_data()

print(x_train.shape)  # (60000, 28, 28)
print(y_train.shape)  # (60000,)
print(y_train[:3])  # array([7, 2, 1], dtype=uint8)


reg = ak.ImageRegressor(overwrite=True, max_trials=1)
# Feed the image regressor with training data.
reg.fit(x_train, y_train, epochs=2)


# Predict with the best model.
predicted_y = reg.predict(x_test)
print(predicted_y)


# Evaluate the best model with testing data.
print(reg.evaluate(x_test, y_test))

# reg.fit(
#     x_train,
#     y_train,
#     # Split the training data and use the last 15% as validation data.
#     validation_split=0.15,
#     epochs=2,
# )
#
# split = 50000
# x_val = x_train[split:]
# y_val = y_train[split:]
# x_train = x_train[:split]
# y_train = y_train[:split]
# reg.fit(
#     x_train,
#     y_train,
#     # Use your own validation set.
#     validation_data=(x_val, y_val),
#     epochs=2,
# )
#
#
# input_node = ak.ImageInput()
# output_node = ak.ImageBlock(
#     # Only search ResNet architectures.
#     block_type="resnet",
#     # Normalize the dataset.
#     normalize=False,
#     # Do not do data augmentation.
#     augment=False,
# )(input_node)
# output_node = ak.RegressionHead()(output_node)
# reg = ak.AutoModel(
#     inputs=input_node, outputs=output_node, overwrite=True, max_trials=1
# )
# reg.fit(x_train, y_train, epochs=2)