import os
import sys
import time

import cv2
import numpy as np
from PyQt5 import QtCore, QtWidgets
from PyQt5.QtCore import QTimer
from PyQt5.QtGui import QPixmap, QImage
from PyQt5.QtWidgets import QMessageBox
from pipython import GCSDevice, pitools

from mikrotron import MikrotronCLCamera
from mt_ui import Ui_MainWindow

_translate = QtCore.QCoreApplication.translate


class main_ui(QtWidgets.QMainWindow, Ui_MainWindow):
    def __init__(self):
        super(main_ui, self).__init__()
        self.pos = [0, 0, 0]
        self.setupUi(self)
        self.camera_flag = False
        self.motor1_init()
        self.motor2_init()
        self.motor3_init()

        # camera
        self.camera = None
        self.camera_timer = QTimer()
        self.camera_timer.timeout.connect(self.show_img)
        self.pushButton_video.clicked.connect(self.open_camera)

        # motor
        self.pushButton_m1.clicked.connect(self.motor1_clicked)
        self.pushButton_m2.clicked.connect(self.motor2_clicked)
        self.pushButton_m3.clicked.connect(self.motor3_clicked)
        self.pushButton_rec.clicked.connect(self.record)
        self.pushButton_exoset.clicked.connect(self.exposure_set)

        self.lasttime = 0

    def motor1_init(self):
        self.motor1 = GCSDevice('C-863')
        self.motor1.ConnectUSB('0020550202')
        print('connected: {}'.format(self.motor1.qIDN().strip()))

        rangemin = list(self.motor1.qTMN().values())
        rangemax = list(self.motor1.qTMX().values())

        print('motor1', rangemin, rangemax)

        pos = self.motor1.qPOS()
        print(pos)

        self.motor1.MOV(1, 25)
        pitools.waitontarget(self.motor1)

        pos = self.motor1.qPOS()
        print(pos)
        self.label_m1.setText(_translate("MainWindow", str(pos['1'])))

    def motor2_init(self):
        self.motor2 = GCSDevice('C-863')
        self.motor2.ConnectUSB('0195500097')
        print('connected: {}'.format(self.motor2.qIDN().strip()))

        rangemin = list(self.motor2.qTMN().values())
        rangemax = list(self.motor2.qTMX().values())
        print('motor2', rangemin, rangemax)
        pos = self.motor2.qPOS()

        self.label_m2.setText(_translate("MainWindow", str(pos['1'])))

    def motor3_init(self):
        self.motor3 = GCSDevice('E-754')
        self.motor3.ConnectUSB('120047497')
        print('connected: {}'.format(self.motor3.qIDN().strip()))

        rangemin = list(self.motor3.qTMN().values())
        rangemax = list(self.motor3.qTMX().values())
        print('motor3', rangemin, rangemax)
        pos = self.motor3.qPOS()

        self.label_m3.setText(_translate("MainWindow", str(pos['1'])))

    def show_img(self):

        try:
            ret = self.camera.read()
        except Exception as r:
            return r

        ret = cv2.cvtColor(ret, cv2.COLOR_GRAY2RGB)
        ret = cv2.resize(ret, (256, 320))
        h, w = ret.shape[:2]

        # cv2.imshow('ret', ret)
        ret = QImage(ret.data, w, h, 3 * w, QImage.Format.Format_RGB888)

        self.img.setPixmap(QPixmap.fromImage(ret).scaled(h, w))

        time_now = time.time()
        print('2', time_now - self.lasttime)
        self.lasttime = time_now

    def open_camera(self):
        if not self.camera_flag:

            self.camera = MikrotronCLCamera()
            self.camera.open_camera()
            self.camera.set('exposure', 5)
            self.camera_timer.start(10)
            err = self.show_img()
            if err:
                QMessageBox.about(self, 'alert', 'open camera failed, try again')
                self.camera_flag = False
            else:
                self.camera_flag = True

        else:
            QMessageBox.about(self, 'alert', 'camera already on')

    def motor1_clicked(self):
        pos = float(self.lineEdit_m1.text())
        st = time.time()
        self.motor1.MOV(1, pos)
        pitools.waitontarget(self.motor1)
        ed = time.time()
        print(ed - st)
        st = time.time()
        pos = self.motor1.qPOS()
        ed = time.time()
        print(ed - st)
        self.label_m1.setText(_translate("MainWindow", str(pos['1'])))

    def motor2_clicked(self):
        pos = float(self.lineEdit_m2.text())
        st = time.time()
        self.motor2.MOV(1, pos)
        pitools.waitontarget(self.motor2)
        ed = time.time()
        print(ed - st)
        st = time.time()
        pos = self.motor2.qPOS()
        ed = time.time()
        print(ed - st)
        self.label_m2.setText(_translate("MainWindow", str(pos['1'])))

    def motor3_clicked(self):
        pos = float(self.lineEdit_m3.text())
        st = time.time()
        self.motor3.MOV(1, pos)
        pitools.waitontarget(self.motor3)
        ed = time.time()
        print(ed - st)
        st = time.time()
        pos = self.motor3.qPOS()
        ed = time.time()
        print(ed - st)
        self.label_m3.setText(_translate("MainWindow", str(pos['1'])))

    def record(self):
        st = float(self.lineEdit_st.text())
        ed = float(self.lineEdit_ed.text())
        step = float(self.lineEdit_step.text())
        focus = float(self.lineEdit_focus.text())
        r = np.arange(st, ed, step)
        time_now = time.localtime()
        filepath = time.strftime("%Y-%m-%d-%H_%M_%S", time_now)
        os.mkdir(filepath)
        vfp = os.path.join(filepath, 'video.avi')
        # video = cv2.VideoWriter(vfp, cv2.VideoWriter_fourcc(*'MJPG'), 5, (1024, 1280), isColor=False)
        video = cv2.VideoWriter(vfp, cv2.VideoWriter_fourcc(*'MJPG'), 30, (1280, 1024), isColor=False)
        # os.path.join()
        st = time.time()
        for pos in r:

            self.motor1.MOV(1, pos)
            pitools.waitontarget(self.motor2)
            self.pos[0] = self.motor1.qPOS()
            pos2 = self.motor2.qPOS()
            pos3 = self.motor3.qPOS()
            for c in range(10):
                ret = self.camera.read()
                fp = f'{pos}_{c}.jpg'
                fp = os.path.join(filepath, fp)
                cv2.imwrite(fp, ret)
                video.write(ret)
        video.release()
        ed = time.time()
        dur = ed - st
        QMessageBox.about(self, 'notice', f'finished! time:{dur}')

    def exposure_set(self):

        if self.camera_flag:
            exp = float(self.lineEdit_exposure.text())
            self.camera.set('exposure', exp)
        else:
            QMessageBox.about(self, 'alert', 'camera not open!')


app = QtWidgets.QApplication(sys.argv)
myshow = main_ui()
myshow.show()
sys.exit(app.exec_())
