import copy
import csv
import os
import pickle
import sys
import time
from copy import deepcopy

import cv2
import numpy as np
import seaborn as sns
import serial

from PyQt5 import QtCore, QtWidgets
from PyQt5.QtCore import QTimer, QThread, pyqtSignal
from PyQt5.QtGui import QPixmap, QImage
from PyQt5.QtWidgets import QMessageBox
from matplotlib import pyplot as plt
from pipython import GCSDevice, pitools

from mikrotron import MikrotronCLCamera
from mt_ui import Ui_MainWindow
from camerasetting_ui import Ui_camera_setting

_translate = QtCore.QCoreApplication.translate


def move_motor(motor, pos):
    motor.MOV(1, pos)
    pitools.waitontarget(motor)


class VideoWrite(QThread):
    def __init__(self, fp=None, n=None):
        super(VideoWrite, self).__init__()
        self.fp = fp
        self.n = n

    def run(self):
        ifp = os.path.join(self.fp, 'img')
        vfp = os.path.join(self.fp, '1_2_3_4.avi')
        video = cv2.VideoWriter(vfp, cv2.VideoWriter_fourcc(*'MJPG'), 50, (1280, 1024), isColor=False)
        for i in range(self.n):
            fp = os.path.join(ifp, f'{i}.jpg')
            frame = cv2.imread(fp, 0)
            video.write(frame)
        video.release()


class FrameSave(QThread):
    def __init__(self, fp=None, frame=None):
        super(FrameSave, self).__init__()
        self.fp = fp
        self.frame = frame
        # print(fp)

    def run(self):
        # print(self.fp)
        cv2.imwrite(self.fp, self.frame)


class main_ui(QtWidgets.QMainWindow, Ui_MainWindow):

    def __init__(self):
        super(main_ui, self).__init__()
        self.framerate = 500
        self.pos = [0, 0, 0]
        self.setupUi(self)
        self.camera_flag = False
        self.motor1_init()
        self.motor2_init()
        self.motor3_init()
        self.tasklist = []
        # camera
        self.camera = None
        self.camera_timer = QTimer()
        self.camera_timer.timeout.connect(self.show_img)
        self.pushButton_video.clicked.connect(self.open_camera)

        # motor
        self.doubleSpinBox.editingFinished.connect(self.motor1_clicked)
        self.doubleSpinBox_2.valueChanged.connect(self.motor2_clicked)
        self.doubleSpinBox_3.editingFinished.connect(self.motor3_clicked)
        self.pushButton_move3.clicked.connect(self.move3)
        self.pushButton_rec.clicked.connect(self.movex)
        self.pushButton_exoset.clicked.connect(self.exposure_set)
        self.pushButton_BLUT.clicked.connect(self.build_LUT)
        self.pushButton_camerasetting.clicked.connect(self.bgscan)

        self.lasttime = 0
        self.t = []

        portx = 'COM4'
        bps = 38400
        timex = 3
        self.motorx = serial.Serial(portx, bps, timeout=timex)
        self.st = 0
        self.ed = 0

    def motor1_init(self):
        self.motor1 = GCSDevice('C-863')
        self.motor1.ConnectUSB('0020550202')
        self.doubleSpinBox.setValue(1)
        # print('connected: {}'.format(self.motor1.qIDN().strip()))
        #
        # rangemin = list(self.motor1.qTMN().values())
        # rangemax = list(self.motor1.qTMX().values())
        #
        # print('motor1', rangemin, rangemax)
        #
        # pos = self.motor1.qPOS()
        # print(pos)
        #
        self.motor1.MOV(1, 25)
        pitools.waitontarget(self.motor1)
        #
        # pos = self.motor1.qPOS()
        # print(pos)
        # self.label_m1.setText(_translate("MainWindow", str(pos['1'])))

    def motor2_init(self):
        self.motor2 = GCSDevice('C-863')
        self.motor2.ConnectUSB('0195500097')
        self.doubleSpinBox_2.setValue(0)
        # print('connected: {}'.format(self.motor2.qIDN().strip()))
        #
        # rangemin = list(self.motor2.qTMN().values())
        # rangemax = list(self.motor2.qTMX().values())
        # print('motor2', rangemin, rangemax)
        # pos = self.motor2.qPOS()
        #
        # self.label_m2.setText(_translate("MainWindow", str(pos['1'])))

    def motor3_init(self):
        self.motor3 = GCSDevice('E-754')
        self.motor3.ConnectUSB('120047497')
        self.doubleSpinBox_3.setValue(40)
        # print('connected: {}'.format(self.motor3.qIDN().strip()))
        #
        rangemin = list(self.motor3.qTMN().values())
        rangemax = list(self.motor3.qTMX().values())
        print('motor3', rangemin, rangemax)
        # pos = self.motor3.qPOS()
        #
        # self.label_m3.setText(_translate("MainWindow", str(pos['1'])))

    def show_img(self):

        try:
            # start = time.time()
            ret = self.camera.read()
            # end = time.time()
        except Exception as r:
            return r

        ret = cv2.cvtColor(ret, cv2.COLOR_GRAY2RGB)
        ret = cv2.resize(ret, (1024, 1280))
        h, w = ret.shape[:2]

        # cv2.imshow('ret', ret)
        ret = QImage(ret.data, w, h, 3 * w, QImage.Format.Format_RGB888)

        self.img.setPixmap(QPixmap.fromImage(ret).scaled(h, w))

        # time_now = time.time()
        # print('grab time:', end-start)
        # self.lasttime = time_now
        return None

    def open_camera(self):
        if not self.camera_flag:

            self.camera = MikrotronCLCamera()
            self.camera.open_camera()
            self.camera.set('exposure', 0.1)
            self.camera.set('framerate', 500)
            self.camera_timer.start(int(1000 / self.framerate))
            err = self.show_img()
            if err:
                print(err)
                QMessageBox.about(self, 'alert', 'open camera failed, try again')
                self.camera_flag = False
            else:
                self.camera_flag = True

        else:
            QMessageBox.about(self, 'alert', 'camera already on')

    def mover(self, stride, motor, label):
        motor.MVR(1, stride)
        pitools.waitontarget(motor)
        pos = motor.qPOS()
        label.setText(_translate("MainWindow", str(pos['1'])))

    def move3(self):
        stride = float(self.comboBox_m3.currentText())
        pos = float(self.doubleSpinBox_3.text())
        # print(stride, self.checkBox_3.isChecked())
        if self.checkBox_3.isChecked():
            self.mover(stride, self.motor3, self.label_m3)
        else:
            self.mover(-stride, self.motor3, self.label_m3)

    def movex(self):
        if self.checkBox_3.isChecked():
            self.motorx.write('M:1+P1000\r\n'.encode())
            ret = self.motorx.read(4)
            print(ret)
            self.motorx.write(('G:\r\n'.encode()))
            ret = self.motorx.read(4)
            print(ret)
        else:
            self.motorx.write('M:1-P1000\r\n'.encode())
            ret = self.motorx.read(4)
            print(ret)
            self.motorx.write(('G:\r\n'.encode()))
            ret = self.motorx.read(4)
            print(ret)

    def bgscan(self):
        fr = []
        time_now = time.localtime()
        filename = time.strftime("background/%Y-%m-%d-%H_%M_%S.pkl", time_now)
        if self.checkBox_3.isChecked():
            for i in range(1000):
                self.motorx.write('M:1+P100\r\n'.encode())
                ret = self.motorx.read(4)
                # print(ret)
                self.motorx.write(('G:\r\n'.encode()))
                ret = self.motorx.read(4)
                # print(ret)
                frame = self.camera.read()

                fr.append(copy.deepcopy(frame))
            with open(filename, 'wb') as f:
                pickle.dump(fr, f)


        else:
            for i in range(1000):
                self.motorx.write('M:1-P100\r\n'.encode())
                ret = self.motorx.read(4)
                # print(ret)
                self.motorx.write(('G:\r\n'.encode()))
                ret = self.motorx.read(4)
                # print(ret)
                frame = self.camera.read()
                fr.append(frame)
            with open(filename, 'wb') as f:
                pickle.dump(fr, f)


    # def bgscan(self):
    #
    #     st = time.time()
    #     fr = []
    #     if self.checkBox_3.isChecked():
    #         self.motorx.write('M:1+P100000\r\n'.encode())
    #         ret = self.motorx.read(4)
    #         print(ret)
    #         self.motorx.write(('G:\r\n'.encode()))
    #         ret = self.motorx.read(4)
    #         print(ret)
    #
    #     else:
    #         self.motorx.write('M:1-P100000\r\n'.encode())
    #         ret = self.motorx.read(4)
    #         print(ret)
    #         self.motorx.write(('G:\r\n'.encode()))
    #         ret = self.motorx.read(4)
    #         print(ret)
    #     time_now = time.localtime()
    #     filename = time.strftime("background/%Y-%m-%d-%H_%M_%S.pkl", time_now)
    #     # os.mkdir(filepath)
    #     # ifp = os.path.join(filepath, 'img')
    #     # os.mkdir(ifp)
    #     # st = time.time()
    #     for i in range(2500):
    #         frame = self.camera.read()
    #         # fp = os.path.join(ifp, f'{i}.jpg')
    #         # fs = FrameSave(fp=fp, frame=frame)
    #         # fs.finished.connect(self.remove_thread)
    #         # self.tasklist.append(fs)
    #         # fs.start()
    #         fr.append(frame)
    #     ed = time.time()
    #     print('total time:', ed-st)
    #     with open(filename, 'wb') as f:
    #         pickle.dump(fr, f)
    #     # ed = time.time()
    #     # print('total time:', ed-st)
    #     # vw = VideoWrite(filepath, 2500)
    #     # vw.finished.connect(self.video_convert_finished)
    #     # self.tasklist.append(vw)
    #     # vw.start()



    def test_move(self):
        if self.checkBox_3.isChecked():
            stride = 0.001
        else:
            stride = -0.001
        motor = self.motor3
        pos = []
        p = motor.qPOS()
        pos.append(p['1'])
        for i in range(1000):
            motor.MVR(1, stride)
            pitools.waitontarget(self.motor1)
            pos = motor.qPOS()
            pos.append(p['1'])
        stride = [pos[i + 1] - pos[i] for i in range(1000)]
        sns.displot(stride)
        plt.show()
        plt.figure()
        plt.plot(stride)
        plt.show()

    def frameSave(self, ret):

        FrameSave.count += 1
        # print(FrameSave.count)
        if FrameSave.count == 1:
            self.st = time.time()
            # print(st)
        else:
            ed = time.time()
            print(ed - self.st)
            self.st = ed
        fp = ret['fp']
        frame = ret['frame']
        cv2.imwrite(fp, frame)
        # if FrameSave.count >= 499:
        #     ed = time.time()
        #     print(ed-self.st)

    def remove_thread(self):
        sender = self.sender()
        if sender in self.tasklist:
            try:
                self.tasklist.remove(sender)
            except Exception as e:
                print(e)

    def video_convert_finished(self):
        sender = self.sender()
        if sender in self.tasklist:
            try:
                self.tasklist.remove(sender)
                QMessageBox.about(self, 'notice', 'Video convert finished!')
            except Exception as e:
                print(e)

    def build_LUT(self):
        stride_list = [0.0] + [0.01] * 1000
        # stride_list = [0, 1]
        numofimgs = 10
        # steps = int(self.lineEdit_steps.text())
        # stride = float(self.lineEdit_stride.text())
        # pos = float(self.doubleSpinBox_3.text())

        pos = float(self.lineEdit_st_3.text()) - 5
        # pos = st

        move_motor(self.motor3, pos)
        time_now = time.localtime()
        filepath = time.strftime("LUT/%Y-%m-%d-%H_%M_%S", time_now)
        os.mkdir(filepath)
        ifp = os.path.join(filepath, 'img')
        cfp = os.path.join(filepath, 'data.csv')
        os.mkdir(ifp)
        st = time.time()
        # n = int(self.lineEdit_steps.text())
        data = []
        count = 0
        for stride in stride_list:
            pos += stride
            move_motor(self.motor3, pos)
            # self.pos[0] = self.motor3.qPOS()
            frame = np.zeros((1024, 1280), dtype=int)
            for _ in range(numofimgs):
                tempret = deepcopy(self.camera.read())
                frame += tempret
            frame = frame // numofimgs
            frame = frame.astype(np.uint8)
            fp = os.path.join(ifp, f'{count}.jpg')
            count += 1

            fs = FrameSave(fp=fp, frame=frame)
            fs.finished.connect(self.remove_thread)
            self.tasklist.append(fs)
            fs.start()
            self.pos[0] = self.motor3.qPOS()
            data.append([count, self.pos[0]['1']])

        ed = time.time()
        print(ed - st)

        vw = VideoWrite(filepath, count)
        vw.finished.connect(self.video_convert_finished)
        self.tasklist.append(vw)
        vw.start()
        with open(cfp, 'w', encoding='utf-8-sig', newline='') as f:
            writer = csv.writer(f)
            # writer.writerow(['time', 'z'])
            writer.writerows(data)

    #     data = []
    #     for i in range(steps):
    #         move_motor(self.motor3, pos)
    #         self.pos[0] = self.motor3.qPOS()
    #         ret = np.zeros((1024, 1280), dtype=int)
    #
    #         for _ in range(numofimgs):
    #             tempret = deepcopy(self.camera.read())
    #             # plt.imshow(tempret)
    #             ret += tempret
    #         ret = ret // numofimgs
    #         ret = ret.astype(np.uint8)
    #         plt.imshow(ret)
    #         # ret = np.round(ret)
    #         # ret.dtype = int
    #
    #         # ret = self.camera.read()
    #         fp = f'{pos}.jpg'
    #         fp = os.path.join(ifp, fp)
    #         cv2.imwrite(fp, ret)
    #         video.write(ret)
    #         data.append([i, self.pos[0]['1']])
    #         pos = pos + stride
    #         print(pos)
    #         # video.release()
    #     with open(cfp, 'w', encoding='utf-8-sig', newline='') as f:
    #         writer = csv.writer(f)
    #
    #         # writer.writerow(['time', 'z'])
    #
    #         writer.writerows(data)
    #
    #     QMessageBox.about(self, 'notice', 'Finished!')

    def motor1_clicked(self):
        pos = float(self.doubleSpinBox.text())
        st = time.time()
        self.motor1.MOV(1, pos)
        pitools.waitontarget(self.motor1)
        ed = time.time()
        print(ed - st)
        st = time.time()
        pos = self.motor1.qPOS()
        # pos = self.motor1.qTSP()
        ed = time.time()
        print(pos)
        print(ed - st)
        self.label_m1.setText(_translate("MainWindow", str(pos['1'])))

    def motor2_clicked(self):
        pos = float(self.doubleSpinBox_2.text())
        st = time.time()
        self.motor2.MOV(1, pos)
        pitools.waitontarget(self.motor2)
        ed = time.time()
        print(ed - st)
        st = time.time()
        pos = self.motor2.qPOS()
        ed = time.time()
        print(ed - st)
        self.label_m2.setText(_translate("MainWindow", str(pos['1'])))

    def motor3_clicked(self):
        pos = float(self.doubleSpinBox_3.text())
        st = time.time()
        self.motor3.MOV(1, pos)
        pitools.waitontarget(self.motor3)
        ed = time.time()
        print(ed - st)
        st = time.time()
        pos = self.motor3.qPOS()
        ed = time.time()
        print(ed - st)
        self.label_m3.setText(_translate("MainWindow", str(pos['1'])))

    def record(self):
        st = float(self.lineEdit_st.text())
        ed = float(self.lineEdit_ed.text())
        step = float(self.lineEdit_step.text())
        # focus = float(self.lineEdit_focus.text())
        r = np.arange(st, ed, step)
        time_now = time.localtime()
        filepath = time.strftime("%Y-%m-%d-%H_%M_%S", time_now)
        os.mkdir(filepath)
        vfp = os.path.join(filepath, 'video.avi')
        # video = cv2.VideoWriter(vfp, cv2.VideoWriter_fourcc(*'MJPG'), 5, (1024, 1280), isColor=False)
        video = cv2.VideoWriter(vfp, cv2.VideoWriter_fourcc(*'MJPG'), 30, (1280, 1024), isColor=False)
        # os.path.join()
        st = time.time()
        for pos in r:
            self.motor3.MOV(1, pos)
            pitools.waitontarget(self.motor3)
            self.pos[0] = self.motor3.qPOS()
            pos2 = self.motor2.qPOS()
            pos3 = self.motor3.qPOS()
            for c in range(10):
                ret = self.camera.read()
                fp = f'{pos}_{c}.jpg'
                fp = os.path.join(filepath, fp)
                cv2.imwrite(fp, ret)
                video.write(ret)
        video.release()
        ed = time.time()
        dur = ed - st
        QMessageBox.about(self, 'notice', f'finished! time:{dur}')

    def exposure_set(self):

        if self.camera_flag:
            exp = float(self.lineEdit_exposure.text())
            self.camera.set('exposure', exp)
        else:
            QMessageBox.about(self, 'alert', 'camera not open!')

    def framerate_set(self):

        if self.camera_flag:
            frt = float(self.lineEdit_exposure.text())
            self.camera.set('framerate', frt)
            self.framerate = frt
        else:
            QMessageBox.about(self, 'alert', 'camera not open!')


class camera_setting(QtWidgets.QMainWindow, Ui_camera_setting):
    def __init__(self):
        super(camera_setting, self).__init__()

    def init(self):
        ret = myshow.camera.read()
        ret = cv2.cvtColor(ret, cv2.COLOR_GRAY2RGB)
        ret = cv2.resize(ret, (1024, 1280))
        h, w = ret.shape[:2]

        # cv2.imshow('ret', ret)
        ret = QImage(ret.data, w, h, 3 * w, QImage.Format.Format_RGB888)

        self.img.setPixmap(QPixmap.fromImage(ret).scaled(h, w))


app = QtWidgets.QApplication(sys.argv)
myshow = main_ui()
camara_setting_window = camera_setting()
myshow.show()
myshow.pushButton_camerasetting.clicked.connect(camara_setting_window.show)
sys.exit(app.exec_())
