import numpy as np
from matplotlib import pyplot, pyplot as plt
from pipython import GCSDevice
from pipython import datarectools, pitools
import seaborn as sns
from progressbar import ProgressBar
import pickle as pkl
import time
print(sns.__file__)

motor = GCSDevice('E-754')
motor.ConnectUSB('120047497')

stride = 0.002

motor.MOV(1, 40)
pos = []
p = motor.qPOS()
pos.append(p['1'])
print(pos)
progress = ProgressBar()
t = []
st = time.time()
for i in progress(range(100)):
    motor.MVR(1, stride)
    st1 = time.time()
    pitools.waitontarget(motor)
    ed1 = time.time()
    t.append(ed1-st1)
    p = motor.qPOS()
    pos.append(p['1'])
ed = time.time()
print(ed - st)

with open(f'stat_data/stride_{stride}.pkl', 'wb') as f:
    dic = {'pos': pos, 'stride': stride, 'time': t}
    pkl.dump(dic, f)

stride = [pos[i+1]-pos[i] for i in range(100)]
print(np.mean(stride))
print(np.std(stride))
# print(sns.__version__)
# plt.figure()
# sns.distplot(stride)
# plt.show()






