from pipython import GCSDevice, pitools
from random import uniform

with GCSDevice('C-863') as pidevice:
    pidevice.ConnectUSB('0020550202')
    print('connected: {}'.format(pidevice.qIDN().strip()))

    rangemin = list(pidevice.qTMN().values())
    rangemax = list(pidevice.qTMX().values())
    ranges = zip(rangemin, rangemax)
    print(rangemin, rangemax)

    pos = pidevice.qPOS()
    print(pos)

    pidevice.MOV(1, 25)
    pitools.waitontarget(pidevice)

    pos = pidevice.qPOS()
    print(pos['1'])

