from matplotlib import pyplot
from pipython import GCSDevice
from pipython import datarectools, pitools

pidevice = GCSDevice()
pidevice.ConnectUSB('0020550202')

drec = datarectools.Datarecorder(pidevice)
# drec.samplerate = 1  # servo cycles
# drec.sampletime = 1E-5  # seconds
drec.samplefreq = 1000  # Hertz
print('data recorder rate: {:d} servo cycles'.format(drec.samplerate))
print('data recorder rate: ', drec.sampletime, 'seconds')
print('data recorder rate: ', drec.samplefreq)

drec.options = (datarectools.RecordOptions.ACTUAL_POSITION_2,
                datarectools.RecordOptions.COMMANDED_POSITION_1)
drec.sources = pidevice.axes[0]
drec.trigsources = datarectools.TriggerSources.POSITION_CHANGING_COMMAND_1
drec.arm()

readout = 'pos_chg_cmd'  # e.g. from an INI file
drec.trigsources = datarectools.gettrigsources(readout)
drec.maxnumvalues = 2000

# pidevice.MVR(1, -1.0)
# pitools.waitontarget(pidevice)
pidevice.MVR(1, -5.0)
pitools.waitontarget(pidevice)
header, data = drec.getdata()
timescale = [header['SAMPLE_TIME'] * i for i in range(len(data[0]))]
print(data[0])
pyplot.plot(timescale, data[0], color='red')
# pyplot.plot(timescale, data[1], color='blue')
pyplot.xlabel('time (s)')
pyplot.ylabel(header['NAME0'])
pyplot.title('Recorded data over time')
pyplot.grid(True)
pyplot.show()
# pidevice.MVR(1, 1.0)
# pitools.waitontarget(pidevice)
#
# header, data = drec.getdata()
# timescale = [header['SAMPLE_TIME'] * i for i in range(len(data[0]))]
# print(data[0])
# pyplot.plot(timescale, data[0], color='red')
# # pyplot.plot(timescale, data[1], color='blue')
# pyplot.xlabel('time (s)')
# pyplot.ylabel(header['NAME0'])
# pyplot.title('Recorded data over time')
# pyplot.grid(True)
# pyplot.show()

# header = pidevice.qDRR(rectables, offset, numvalues)
# while pidevice.bufstate is not True:
#     print('read data {:.1f}%...'.format(pidevice.bufstate * 100))
#     sleep(0.1)
#
# header, data = drec.getdata()
