import sys

from matplotlib import pyplot as plt
from tqdm import tqdm

from progressbar import ProgressBar

from mikrotron import MikrotronCLCamera
import cv2
import time
import seaborn as sns
from utils import pkl_dump, pkl_load
camera = MikrotronCLCamera()

camera.open_camera()
camera.set('exposure', 1.99)
camera.set('framerate', 500)
t = []

for i in tqdm(range(100)):
    start = time.time()
    video = cv2.VideoWriter('video.avi', cv2.VideoWriter_fourcc(*'MJPG'), 30, (1280, 1024), isColor=False)
    for _ in range(500):
        ret = camera.read()
        video.write(ret)
        # cv2.imshow("Frame rate: "+str(end-start),ret)
    end = time.time()
    video.release()
    t.append(end-start)

# print(end-start)
# When everything done, release the capture
pkl_dump('stat_data/time_framerate500_video.pkl', t)
camera.release()
cv2.destroyAllWindows()

sns.distplot(t)
plt.show()
