from pipython import GCSDevice, pitools
from random import uniform

with GCSDevice('E-754') as pidevice:
    pidevice.ConnectUSB('120047497')
    print('connected: {}'.format(pidevice.qIDN().strip()))

    rangemin = list(pidevice.qTMN().values())
    rangemax = list(pidevice.qTMX().values())
    ranges = zip(rangemin, rangemax)

    print(rangemin, rangemax)

    pos = pidevice.qPOS()
    print(pos)

    print(ranges)

    pidevice.MOV(1, 0)
    pitools.waitontarget(pidevice)

    pos = pidevice.qPOS()
    print(pos)