# -*- encoding: utf-8 -*-
'''
@File    :   tk_study.py
@Time    :   2021/04/08 00:18:57
@Author  :   Muyao ZHONG 
@Version :   1.0
@Contact :   zmy125616515@hotmail.com
@License :   (C)Copyright 2019-2020
@Title   :   study tk
'''


import tkinter as tk
from tkinter import *


class gWindow:
    def __init__(self):
        self.main = tk.Tk()
        self.cc = tk.colorchooser.Chooser(master=None)

    def run(self):
        self.main.mainloop()

    def __call__(self):
        self.run()


class Application(tk.Frame):
    def __init__(self, master=None, title="Test APP", max_width=1000, max_height=800):
        if master is None:
            master = tk.Tk()
        super().__init__(master)
        self.master = master
        self.master.title(title)
        self.master.maxsize(max_width, max_height)
        self.master.minsize(600, 400)
        self.pack()
        self.create_widgets()

    def create_widgets(self):
        self.hi_there = tk.Button(self)
        self.hi_there['text'] = "Hello world!\n(click me)"
        self.hi_there["command"] = self.say_hi
        self.hi_there.config(cursor='hand2', bg='#345',)
        self.hi_there['justify'] = 'left'
        self.hi_there.pack(side='top')
        # self.hi_there.bind('<Enter>', self.turn_red)
        self.quit = tk.Button(self, text="QUIT", fg='red', bg='black',
                              command=self.master.destroy)
        self.quit.pack(side='bottom')

    def turn_red(self, event):
        event.widget['activeforeground'] = 'red'

    def say_hi(self):
        print("hi there,everyone!")

    def __call__(self):
        self.mainloop()


if __name__ == "__main__":
    root = tk.Tk()
    # g = Application(master=root)
    mask = tk.READABLE | tk.WRITABLE
    b = tk.Button(root)
    b.pack(side='top')
    b.tk.createfilehandler()
    root.mainloop()
