### 简单的建立窗口
```python
from tkinter import *

root=Tk()
root.title("设置Title")
root.geometry("300x600+100+200")# (wxh+x+y)
root.configure(bg='yellow')
root.mainloop()
# resizeable(True,True) 宽和高是否可以更改大小
#state("zoomed")最大化窗口
#icoify() 最小化窗口
#iconbitmap("xx.ico") 更改默认窗口图标
#minsize(w,h),maxsize(w,h),
```
* 颜色可以用8位十六进制数字表示如`#00ff00`
* 所有颜色名字及其十六进制值如下所示：
![img](imgs/album_temp_1622442761.PNG)
![img](imgs/album_temp_1622442772.PNG)
![img](imgs/album_temp_1622442781.PNG)
![img](imgs/album_temp_1622442786.PNG)

### Widget
1. Button
2. Canvas
3. Checkbutton
4. Entry
5. Frame
6. Label
7. LabelFrame(框架标签)
8. Listbox
9. Menu
10. MenuButton(已过时)
11. Message
12. OpitionMenu
13. PanedWindow
14. Radiobutton
15. Scale
16. Scrollbar
17. Text
18. Toplevel
    
ttk新增Widget
1. Combobox
2. Notebook
3. Progressbar
4. Separator
5. Sizegrip
6. Treeview

可以通过下面方式导入增强模块：
```python
from tkinter import *
from tkinter.ttk import *
```
ttk有更好的外观，而且可以跨平台，但是兼容性不如tk。

Widget共同属性：
```python
Dimensions
Colors
Fonts
Anchor
Relief styles#属性边框
Bitmaps
Cursors
```
Widget共同方法：
```python
Configuration
```
通过key()可以获取部件的所有属性，通过cget(key)可以获取属性值
以下为button的默认属性值：

| key                 | value                       |
| ------------------- | --------------------------- |
| activebackground    | systemWindowBackgroundColor |
| activeforeground    | White                       |
| anchor              | center                      |
| background          | systemWindowBackgroundColor |
| bd                  | 2                           |
| bg                  | systemWindowBackgroundColor |
| bitmap              |                             |
| borderwidth         | 2                           |
| command             |                             |
| compound            | none                        |
| cursor              |                             |
| default             | disabled                    |
| disabledforeground  | #a3a3a3                     |
| fg                  | systemTextColor             |
| font                | TkDefaultFont               |
| foreground          | systemTextColor             |
| height              | 0                           |
| highlightbackground | systemWindowBackgroundColor |
| highlightcolor      | systemButtonFrame           |
| highlightthickness  | 1                           |
| image               |                             |
| justify             | center                      |
| overrelief          |                             |
| padx                | 1                           |
| pady                | 1                           |
| relief              | flat                        |
| repeatdelay         | 0                           |
| repeatinterval      | 0                           |
| state               | normal                      |
| takefocus           |                             |
| text                |                             |
| textvariable        |                             |
| underline           | -1                          |
| width               | 0                           |
| wraplength          | 0                           |

通过`config(option=value)`可以设置对应的属性。

```python
# 事件方法
mainloop()
quit()
update()

# 回掉事件
bind(event,callback)
unbind(event)
after(time,callback)

```
