# -*- encoding: utf-8 -*-
'''
@File    :   window.py
@Time    :   2021/11/13 02:07:49
@Author  :   Muyao ZHONG 
@Version :   1.0
@Contact :   zmy125616515@hotmail.com
@License :   (C)Copyright 2019-2020
@Title   :   all window
'''

import sys
import os
sys.path.append(os.path.abspath('./'))

import pygame
from pygame.locals import *

pygame.init()

class Window:
    def __init__(self,width=1080,height=720,caption="Default"):
        self.image_folder="./GamePackage/GameWindow/"
        self.display=pygame.display
        self.image=pygame.image
        self.event=pygame.event
        self.display.set_mode((width,height))
        self.display.set_caption(caption)
        self.screen=self.display.get_surface()
        self.resources={
            "img":[]
        }
        
        
    def load_image(self,img_name,x,y):
        self.resources["img"].append((self.image.load(self.image_folder+img_name),x,y))
    
    def update(self):
        for r in self.resources["img"]:
            self.screen.blit(r[0],(r[1],r[2]))
        self.display.flip()
        
    def event_handler(self,events):
        for event in events:
            if event.type==QUIT:
                sys.exit(0)
            else:
                pass
                # print(event)
                
    def run(self):
        while True:
            self.update()
            self.event_handler(self.event.get())
            
if __name__ == '__main__':
    w=Window()
    w.load_image("1.jpg",0,0)
    w.load_image("2.jpg",500,0)
    
    w.run()
        