# -*- encoding: utf-8 -*-
'''
@File    :   tools.py
@Time    :   2021/11/09 17:00:17
@Author  :   Muyao ZHONG 
@Version :   1.0
@Contact :   zmy125616515@hotmail.com
@License :   (C)Copyright 2019-2020
@Title   :   all tools are assembled here
'''

import sys
import os
from tkinter.constants import HORIZONTAL
sys.path.append(os.path.abspath('./'))

from tkinter import *
from tkinter import Tk, Menu, messagebox, PanedWindow
from tkinter.ttk import Notebook,Treeview
from base import BaseTool



class GameStudio(BaseTool):
    def __init__(self, name="PyEngine Studio", root=None) -> None:
        super().__init__(name, root=root)
        menubar=Menu(self.root)
        filemenu=Menu(menubar,tearoff=False)
        menubar.add_cascade(label="File",menu=filemenu,underline=0)
        filemenu.add_command(label="About",command=self.Hello,underline=0)
        filemenu.add_separator()
        filemenu.add_command(label="Exit!",command=self.root.destroy)
        self.root.config(menu=menubar)
        
        # ## PanedWindow 
        # pw = PanedWindow(orient=HORIZONTAL)
        # pw.pack(fill=BOTH,expand=True)
        
        # top = Label(pw,text="Top Pane")
        # pw.add(top)
        
        # bottom=Label(pw,text="Bottom Pane")
        # pw.add(bottom)
        # Notebook
        notebook= Notebook(self.root)
        frame1=Frame()
        frame2=Frame()
        
        notebook.add(frame1,text="成就")
        notebook.add(frame2,text="任务")
        notebook.pack(fill=BOTH,expand=TRUE)
        
        # TreeView
        tree=Treeview(frame1,columns=("Name","Describe","Target","Progress","Date","Reward"))
        tree.heading("#0",text="编号")
        tree.heading("#1",text="名称")
        
        tree.insert("",index=END,text="1",values=("打开","第一次打开","1","0","","Hellow"))
        tree.pack()
        
        
        

        
    def Hello(self):
        messagebox.showinfo("About","欢迎使用本软件！\n v0.0.1 版本\n CopyRight 2021-2022")
        
    # def run(self):
    #     self.root.mainloop()
        
if __name__ == '__main__':
    gs=GameStudio()
    gs.run()
        